/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.datatype.DecimalDataType;
import com.github.sidhant92.boolparser.datatype.LongDataType;
import com.github.sidhant92.boolparser.operator.arithmetic.AbstractOperator;
import com.github.sidhant92.boolparser.util.ValueUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ExponentOperator
extends AbstractOperator {
    @Override
    public Object evaluate(Object leftOperand, DataType leftOperandDataType, Object rightOperand, DataType rightOperandDataType) {
        if (leftOperandDataType.equals((Object)DataType.DECIMAL) || rightOperandDataType.equals((Object)DataType.DECIMAL)) {
            DecimalDataType decimalDataType = (DecimalDataType)DataTypeFactory.getDataType(DataType.DECIMAL);
            return ValueUtils.castDecimal(Math.pow(decimalDataType.getValue(leftOperand).get().doubleValue(), decimalDataType.getValue(rightOperand).get().doubleValue()));
        }
        LongDataType longDataType = (LongDataType)DataTypeFactory.getDataType(DataType.LONG);
        return ValueUtils.castDecimal(Math.pow(longDataType.getValue(leftOperand).get().longValue(), longDataType.getValue(rightOperand).get().longValue()));
    }

    @Override
    public Operator getOperator() {
        return Operator.EXPONENT;
    }

    @Override
    public String getSymbol() {
        return "^";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL);
    }
}

