/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.arithmetic.AbstractOperator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UnaryOperator
extends AbstractOperator {
    @Override
    public Object evaluate(Object leftOperand, DataType leftOperandDataType, Object rightOperand, DataType rightOperandDataType) {
        if (leftOperandDataType.equals((Object)DataType.DECIMAL)) {
            return ((BigDecimal)leftOperand).negate();
        }
        if (leftOperandDataType.equals((Object)DataType.LONG)) {
            return -((Long)leftOperand).longValue();
        }
        return -((Integer)leftOperand).intValue();
    }

    @Override
    public Operator getOperator() {
        return Operator.UNARY;
    }

    @Override
    public String getSymbol() {
        return "UNARY";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL);
    }
}

