/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.comparison;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.comparison.AbstractOperator;
import com.github.sidhant92.boolparser.operator.comparison.InOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class ContainsAnyOperator
extends AbstractOperator {
    private final InOperator inOperator;

    @Override
    public <T extends Comparable<? super T>> boolean evaluate(ContainerDataType containerDataType, Object leftOperand, DataType leftOperandDataType, List<Pair<Object, DataType>> rightOperands) {
        if (!containerDataType.isValid(leftOperandDataType, leftOperand)) {
            return false;
        }
        List leftOperandArray = Arrays.stream(((List)leftOperand).toArray()).map(a -> Pair.of((Object)a, (Object)((Object)leftOperandDataType))).collect(Collectors.toList());
        return rightOperands.stream().anyMatch(rightOperand -> this.inOperator.evaluate(ContainerDataType.PRIMITIVE, rightOperand.getLeft(), (DataType)((Object)((Object)rightOperand.getRight())), leftOperandArray));
    }

    @Override
    public Operator getOperator() {
        return Operator.CONTAINS_ANY;
    }

    @Override
    public String getSymbol() {
        return "CONTAINS_ANY";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.LIST);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.values());
    }

    @Generated
    public ContainsAnyOperator(InOperator inOperator) {
        this.inOperator = inOperator;
    }
}

