/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.parser.antlr;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.FunctionType;
import com.github.sidhant92.boolparser.constant.LogicalOperationType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.FieldNode;
import com.github.sidhant92.boolparser.domain.arithmetic.ArithmeticFunctionNode;
import com.github.sidhant92.boolparser.domain.arithmetic.ArithmeticNode;
import com.github.sidhant92.boolparser.domain.arithmetic.UnaryNode;
import com.github.sidhant92.boolparser.domain.logical.ArrayNode;
import com.github.sidhant92.boolparser.domain.logical.BooleanNode;
import com.github.sidhant92.boolparser.domain.logical.ComparisonNode;
import com.github.sidhant92.boolparser.domain.logical.InNode;
import com.github.sidhant92.boolparser.domain.logical.Node;
import com.github.sidhant92.boolparser.domain.logical.NumericRangeNode;
import com.github.sidhant92.boolparser.exception.InvalidExpressionException;
import com.github.sidhant92.boolparser.parser.antlr.BooleanExpressionBaseListener;
import com.github.sidhant92.boolparser.parser.antlr.BooleanExpressionParser;
import com.github.sidhant92.boolparser.util.ValueUtils;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.commons.lang3.StringUtils;

public class BooleanFilterListener
extends BooleanExpressionBaseListener {
    private Node node;
    private final Stack<Node> currentNodes;
    private Token lastToken;
    private int tokenCount;
    private final String defaultField;

    public BooleanFilterListener(String defaultField) {
        this.defaultField = defaultField;
        this.node = null;
        this.lastToken = null;
        this.currentNodes = new Stack();
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void exitComparatorExpression(BooleanExpressionParser.ComparatorExpressionContext ctx) {
        this.currentNodes.add(this.mapComparatorExpressionContext(ctx));
        super.enterComparatorExpression(ctx);
    }

    @Override
    public void exitArithmeticExpression(BooleanExpressionParser.ArithmeticExpressionContext ctx) {
        this.currentNodes.add(this.mapArithmeticExpressionContext(ctx));
        super.exitArithmeticExpression(ctx);
    }

    @Override
    public void exitUnaryArithmeticExpression(BooleanExpressionParser.UnaryArithmeticExpressionContext ctx) {
        Node leafNode = !this.currentNodes.isEmpty() && this.currentNodes.peek() instanceof ArithmeticNode ? this.currentNodes.pop() : this.mapTypesExpressionContext((BooleanExpressionParser.TypesExpressionContext)ctx.exp);
        this.currentNodes.add(ArithmeticNode.builder().left(leafNode).operator(Operator.UNARY).build());
        super.enterUnaryArithmeticExpression(ctx);
    }

    @Override
    public void exitToExpression(BooleanExpressionParser.ToExpressionContext ctx) {
        this.currentNodes.add(this.mapToExpressionContext(ctx));
        super.exitToExpression(ctx);
    }

    @Override
    public void exitArrayExpression(BooleanExpressionParser.ArrayExpressionContext ctx) {
        this.validateField(ctx.field, ctx.getText());
        String field = this.getField(ctx.field.getText());
        List<Node> items = this.getArrayElements(ctx.data.children);
        Operator operator = Operator.getOperatorFromSymbol(ctx.op.getText()).orElse(Operator.EQUALS);
        this.currentNodes.add(new ArrayNode(field, operator, items));
        super.exitArrayExpression(ctx);
    }

    @Override
    public void exitArithmeticFunctionExpression(BooleanExpressionParser.ArithmeticFunctionExpressionContext ctx) {
        ArithmeticFunctionNode node = this.mapArithmeticFunctionExpressionContext(ctx);
        this.currentNodes.add(node);
        super.exitArithmeticFunctionExpression(ctx);
    }

    @Override
    public void exitInExpression(BooleanExpressionParser.InExpressionContext ctx) {
        this.currentNodes.add(this.mapInExpressionContext(ctx));
        super.exitInExpression(ctx);
    }

    private List<Node> getArrayElements(List<ParseTree> trees) {
        return trees.stream().filter(child -> !(child instanceof TerminalNodeImpl)).map(this::mapContextToNode).collect(Collectors.toList());
    }

    private Node mapContextToNode(ParseTree ctx) {
        if (ctx instanceof BooleanExpressionParser.ArithmeticExpressionContext) {
            return this.mapArithmeticExpressionContext((BooleanExpressionParser.ArithmeticExpressionContext)ctx);
        }
        if (ctx instanceof BooleanExpressionParser.InExpressionContext) {
            return this.mapInExpressionContext((BooleanExpressionParser.InExpressionContext)ctx);
        }
        if (ctx instanceof BooleanExpressionParser.ArithmeticFunctionExpressionContext) {
            return this.mapArithmeticFunctionExpressionContext((BooleanExpressionParser.ArithmeticFunctionExpressionContext)ctx);
        }
        if (ctx instanceof BooleanExpressionParser.ComparatorExpressionContext) {
            return this.mapComparatorExpressionContext((BooleanExpressionParser.ComparatorExpressionContext)ctx);
        }
        if (ctx instanceof BooleanExpressionParser.ToExpressionContext) {
            return this.mapToExpressionContext((BooleanExpressionParser.ToExpressionContext)ctx);
        }
        if (ctx instanceof BooleanExpressionParser.TypesExpressionContext && ((BooleanExpressionParser.TypesExpressionContext)ctx).start.getType() == 44) {
            return this.mapTypesExpressionContextField((BooleanExpressionParser.TypesExpressionContext)ctx);
        }
        if (ctx instanceof BooleanExpressionParser.TypesExpressionContext) {
            return this.mapTypesExpressionContext((BooleanExpressionParser.TypesExpressionContext)ctx);
        }
        throw new InvalidExpressionException(String.format("Array does not support this expression %s", ctx.getText()));
    }

    private FieldNode mapTypesExpressionContextField(BooleanExpressionParser.TypesExpressionContext ctx) {
        String value = StringUtils.isBlank((CharSequence)ctx.getText()) ? this.defaultField : ctx.getText();
        return new FieldNode(value);
    }

    private Node mapTypesExpressionContext(BooleanExpressionParser.TypesExpressionContext ctx) {
        if (ctx.start.getType() == 44) {
            return this.mapTypesExpressionContextField(ctx);
        }
        if (StringUtils.isBlank((CharSequence)ctx.getText())) {
            return this.mapTypesExpressionContextField(ctx);
        }
        DataType dataType = this.getDataType(ctx.start);
        Object value = ValueUtils.convertValue(ctx.start.getText(), dataType);
        return new UnaryNode(dataType, value);
    }

    private ArithmeticFunctionNode mapArithmeticFunctionExpressionContext(BooleanExpressionParser.ArithmeticFunctionExpressionContext ctx) {
        if (ctx.data.exception != null) {
            throw new InvalidExpressionException(String.format("Error parsing expression for the string %s", ctx.getText()));
        }
        FunctionType functionType = FunctionType.getArrayFunctionFromSymbol(ctx.left.getText()).orElseThrow(() -> new InvalidExpressionException(String.format("Error parsing expression for the string %s", ctx.getText())));
        List<Node> items = this.getArrayElements(ctx.data.children);
        return new ArithmeticFunctionNode(functionType, items);
    }

    private ComparisonNode mapComparatorExpressionContext(BooleanExpressionParser.ComparatorExpressionContext ctx) {
        Operator operator = Operator.getOperatorFromSymbol(ctx.op.getText()).orElse(Operator.EQUALS);
        if (!this.currentNodes.isEmpty() && (ctx.right instanceof BooleanExpressionParser.ParentExpressionContext || ctx.left instanceof BooleanExpressionParser.ParentExpressionContext || !(this.currentNodes.peek() instanceof ComparisonNode) && !(this.currentNodes.peek() instanceof BooleanNode))) {
            if (ctx.left instanceof BooleanExpressionParser.TypesExpressionContext) {
                DataType dataType = this.getDataType(ctx.left.getStart());
                Node value = this.mapContextToNode((ParseTree)ctx.left);
                return new ComparisonNode(value, this.currentNodes.pop(), operator, dataType);
            }
            if (ctx.right instanceof BooleanExpressionParser.TypesExpressionContext) {
                DataType dataType = this.getDataType(ctx.right.getStart());
                Node value = this.mapContextToNode((ParseTree)ctx.right);
                return new ComparisonNode(this.currentNodes.pop(), value, operator, dataType);
            }
        }
        DataType dataType = this.getDataType(ctx.right.getStart());
        Node value = this.mapContextToNode((ParseTree)ctx.right);
        return new ComparisonNode(this.mapContextToNode((ParseTree)ctx.left), value, operator, dataType);
    }

    private ArithmeticNode mapArithmeticExpressionContext(BooleanExpressionParser.ArithmeticExpressionContext ctx) {
        Operator operator = Operator.getOperatorFromSymbol(ctx.op.getText()).orElse(Operator.EQUALS);
        if (ctx.left instanceof BooleanExpressionParser.TypesExpressionContext && ctx.right instanceof BooleanExpressionParser.TypesExpressionContext) {
            Node left = this.mapTypesExpressionContext((BooleanExpressionParser.TypesExpressionContext)ctx.left);
            Node right = this.mapTypesExpressionContext((BooleanExpressionParser.TypesExpressionContext)ctx.right);
            return ArithmeticNode.builder().left(left).right(right).operator(operator).build();
        }
        if (ctx.left instanceof BooleanExpressionParser.TypesExpressionContext) {
            Node left = this.mapTypesExpressionContext((BooleanExpressionParser.TypesExpressionContext)ctx.left);
            Node right = this.currentNodes.pop();
            return ArithmeticNode.builder().left(left).right(right).operator(operator).build();
        }
        if (ctx.right instanceof BooleanExpressionParser.TypesExpressionContext) {
            Node right = this.mapTypesExpressionContext((BooleanExpressionParser.TypesExpressionContext)ctx.right);
            Node left = this.currentNodes.pop();
            return ArithmeticNode.builder().left(left).right(right).operator(operator).build();
        }
        if (this.currentNodes.size() < 2) {
            throw new InvalidExpressionException(String.format("Error parsing expression for the string %s", ctx.getText()));
        }
        Node right = this.currentNodes.pop();
        Node left = this.currentNodes.pop();
        return ArithmeticNode.builder().left(left).right(right).operator(operator).build();
    }

    private Node mapInExpressionContext(BooleanExpressionParser.InExpressionContext ctx) {
        this.validateField(ctx.field, ctx.getText());
        String field = this.getField(ctx.field.getText());
        List<Node> items = this.getArrayElements(ctx.data.children);
        InNode inNode = new InNode(field, items);
        if (Objects.isNull(ctx.not)) {
            return inNode;
        }
        return new BooleanNode(inNode, null, LogicalOperationType.NOT);
    }

    private NumericRangeNode mapToExpressionContext(BooleanExpressionParser.ToExpressionContext ctx) {
        this.validateField(ctx.field, ctx.getText());
        String field = this.getField(ctx.field.getText());
        DataType lowerDataType = this.getDataType(ctx.lower.start);
        Object lowerValue = ValueUtils.convertValue(ctx.lower.start.getText(), lowerDataType);
        DataType upperDataType = this.getDataType(ctx.upper.start);
        Object upperValue = ValueUtils.convertValue(ctx.upper.getText(), upperDataType);
        return new NumericRangeNode(field, lowerValue, upperValue, lowerDataType, upperDataType);
    }

    private void validateField(Token token, String text) {
        if (Objects.isNull(token) || StringUtils.isBlank((CharSequence)token.getText()) && StringUtils.isBlank((CharSequence)this.defaultField)) {
            throw new InvalidExpressionException(String.format("Error parsing expression (missing field) for the string %s", text));
        }
    }

    private String getField(String field) {
        return StringUtils.isBlank((CharSequence)field) ? this.defaultField : field;
    }

    private DataType getDataType(Token token) {
        switch (token.getType()) {
            case 35: {
                return DataType.DECIMAL;
            }
            case 37: {
                return ValueUtils.getNumericDataType(token.getText());
            }
            case 36: {
                return DataType.VERSION;
            }
            case 7: 
            case 8: {
                return DataType.BOOLEAN;
            }
            case 38: {
                return DataType.DATE;
            }
            case 39: {
                return DataType.DATETIME;
            }
        }
        return DataType.STRING;
    }

    private LogicalOperationType getLogicalOperator(Token token) {
        switch (token.getType()) {
            case 4: {
                return LogicalOperationType.AND;
            }
            case 5: {
                return LogicalOperationType.OR;
            }
        }
        return LogicalOperationType.NOT;
    }

    @Override
    public void exitParse(BooleanExpressionParser.ParseContext ctx) {
        if (this.node == null && !this.currentNodes.isEmpty()) {
            this.node = this.currentNodes.pop();
        }
        if (this.node == null && this.tokenCount == 1 && this.lastToken instanceof CommonToken) {
            Node node = this.node = this.lastToken.getType() == 44 ? FieldNode.builder().field(this.lastToken.getText()).build() : UnaryNode.builder().dataType(DataType.STRING).value(ValueUtils.convertValue(this.lastToken.getText(), DataType.STRING).toString()).build();
        }
        if (this.node == null) {
            throw new InvalidExpressionException(String.format("Error parsing expression for the string %s", ctx.getText()));
        }
        super.exitParse(ctx);
    }

    @Override
    public void exitNotExpression(BooleanExpressionParser.NotExpressionContext ctx) {
        if (this.currentNodes.isEmpty()) {
            if (this.lastToken == null) {
                throw new InvalidExpressionException(String.format("Error parsing not expression for the string %s", ctx.getText()));
            }
            DataType dataType = this.getDataType(this.lastToken);
            Object value = ValueUtils.convertValue(this.lastToken.getText(), dataType);
            this.currentNodes.add(new UnaryNode(dataType, value));
        }
        BooleanNode booleanToken = new BooleanNode(this.currentNodes.pop(), null, LogicalOperationType.NOT);
        this.currentNodes.add(booleanToken);
        super.exitNotExpression(ctx);
    }

    @Override
    public void exitTypesExpression(BooleanExpressionParser.TypesExpressionContext ctx) {
        ++this.tokenCount;
        this.lastToken = ctx.start;
    }

    @Override
    public void exitBinaryExpression(BooleanExpressionParser.BinaryExpressionContext ctx) {
        if (this.currentNodes.size() < 2) {
            throw new InvalidExpressionException(String.format("Error parsing binary expression for the string %s", ctx.getText()));
        }
        Node firstNode = this.currentNodes.pop();
        Node secondNode = this.currentNodes.pop();
        LogicalOperationType operator = this.getLogicalOperator(ctx.op.getStart());
        BooleanNode booleanToken = new BooleanNode(secondNode, firstNode, operator);
        this.currentNodes.add(booleanToken);
        super.enterBinaryExpression(ctx);
    }
}

