/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.parser.antlr;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.sidhant92.boolparser.domain.logical.Node;
import com.github.sidhant92.boolparser.operator.OperatorFactory;
import com.github.sidhant92.boolparser.parser.antlr.BoolParser;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Optional;

public class CachedBoolParser
extends BoolParser {
    private final Cache<String, Node> cache;

    public CachedBoolParser(int maxCacheSize) {
        OperatorFactory.initialize();
        this.cache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).build();
    }

    @Override
    public Try<Node> parseExpression(String expression, String defaultField) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.getNode(expression, defaultField));
    }

    @Override
    public Try<Node> parseExpression(String expression) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.getNode(expression, null));
    }

    private Node getNode(String expression, String defaultField) {
        String cacheKey = expression + "_" + Optional.ofNullable(defaultField).orElse("");
        return (Node)this.cache.get((Object)cacheKey, ex -> super.parse(expression, defaultField));
    }
}

