/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.composites;

import com.github.silencesu.behavior3java.constant.B3Status;
import com.github.silencesu.behavior3java.core.Composite;
import com.github.silencesu.behavior3java.core.Tick;

public class MemPriority
extends Composite {
    @Override
    public void onOpen(Tick tick) {
        super.onOpen(tick);
        tick.getBlackboard().setParam("runningChild", 0, tick.getTree().getId(), this.getId());
    }

    @Override
    public B3Status onTick(Tick tick) {
        Integer childId = (Integer)tick.getBlackboard().getParam("runningChild", tick.getTree().getId(), this.getId());
        for (int i = childId.intValue(); i < this.getChildCount(); ++i) {
            B3Status status = this.getChild(i).execute(tick);
            if (status == B3Status.FAILURE) continue;
            if (status == B3Status.RUNNING) {
                tick.getBlackboard().setParam("runningChild", i, tick.getTree().getId(), this.getId());
            }
            return status;
        }
        return B3Status.FAILURE;
    }
}

