/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.core;

import com.github.silencesu.behavior3java.config.BTTreeCfg;
import com.github.silencesu.behavior3java.config.BTTreeProjectCfg;
import com.github.silencesu.behavior3java.core.BaseNode;
import com.github.silencesu.behavior3java.core.BehaviorTree;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BehaviorTreeProject {
    private static final Logger log = LoggerFactory.getLogger(BehaviorTreeProject.class);
    private Map<String, BehaviorTree> titleTreeMap = new HashMap<String, BehaviorTree>();
    private Map<String, BehaviorTree> idTreeMap = new HashMap<String, BehaviorTree>();

    public BehaviorTree findBTTreeByTitle(String treeTitle) {
        return this.titleTreeMap.get(treeTitle.trim());
    }

    public BehaviorTree findBTTreeById(String id) {
        return this.idTreeMap.get(id);
    }

    public void initProject(BTTreeProjectCfg projectCfg, Map<String, Class<? extends BaseNode>> extendNodes) {
        for (BTTreeCfg treeCfg : projectCfg.getData().getTrees()) {
            BehaviorTree behaviorTree = new BehaviorTree();
            behaviorTree.setProjectInfo(this);
            behaviorTree.load(treeCfg, extendNodes);
            this.titleTreeMap.put(treeCfg.getTitle(), behaviorTree);
            this.idTreeMap.put(treeCfg.getId(), behaviorTree);
        }
    }

    public Map<String, BehaviorTree> getTitleTreeMap() {
        return this.titleTreeMap;
    }

    public Map<String, BehaviorTree> getIdTreeMap() {
        return this.idTreeMap;
    }

    public void setTitleTreeMap(Map<String, BehaviorTree> titleTreeMap) {
        this.titleTreeMap = titleTreeMap;
    }

    public void setIdTreeMap(Map<String, BehaviorTree> idTreeMap) {
        this.idTreeMap = idTreeMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BehaviorTreeProject)) {
            return false;
        }
        BehaviorTreeProject other = (BehaviorTreeProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, BehaviorTree> this$titleTreeMap = this.getTitleTreeMap();
        Map<String, BehaviorTree> other$titleTreeMap = other.getTitleTreeMap();
        if (this$titleTreeMap == null ? other$titleTreeMap != null : !((Object)this$titleTreeMap).equals(other$titleTreeMap)) {
            return false;
        }
        Map<String, BehaviorTree> this$idTreeMap = this.getIdTreeMap();
        Map<String, BehaviorTree> other$idTreeMap = other.getIdTreeMap();
        return !(this$idTreeMap == null ? other$idTreeMap != null : !((Object)this$idTreeMap).equals(other$idTreeMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BehaviorTreeProject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BehaviorTree> $titleTreeMap = this.getTitleTreeMap();
        result = result * 59 + ($titleTreeMap == null ? 43 : ((Object)$titleTreeMap).hashCode());
        Map<String, BehaviorTree> $idTreeMap = this.getIdTreeMap();
        result = result * 59 + ($idTreeMap == null ? 43 : ((Object)$idTreeMap).hashCode());
        return result;
    }

    public String toString() {
        return "BehaviorTreeProject(titleTreeMap=" + this.getTitleTreeMap() + ", idTreeMap=" + this.getIdTreeMap() + ")";
    }
}

