/*
 * Decompiled with CFR 0.152.
 */
package com.github.silencesu.behavior3java.decorators;

import com.github.silencesu.behavior3java.config.BTNodeCfg;
import com.github.silencesu.behavior3java.constant.B3Status;
import com.github.silencesu.behavior3java.core.Decorator;
import com.github.silencesu.behavior3java.core.Tick;

public class MaxTime
extends Decorator {
    private long maxTime;

    @Override
    public void initialize(BTNodeCfg nodeCfg) {
        super.initialize(nodeCfg);
        this.maxTime = Long.valueOf(nodeCfg.getProperties().get("maxTime"));
    }

    @Override
    public void onOpen(Tick tick) {
        super.onOpen(tick);
        long startTime = System.currentTimeMillis();
        tick.getBlackboard().setParam("condition", startTime, tick.getTree().getId(), this.getId());
    }

    @Override
    public B3Status onTick(Tick tick) {
        if (this.getChild() == null) {
            return B3Status.ERROR;
        }
        long currTime = System.currentTimeMillis();
        Long startTime = (Long)tick.getBlackboard().getParam("condition", tick.getTree().getId(), this.getId());
        B3Status status = this.getChild().execute(tick);
        if (currTime - startTime > this.maxTime) {
            return B3Status.FAILURE;
        }
        return status;
    }
}

