/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.ImmutableArrayList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableHashMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableHashSet;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Immutable {
    private static final ImmutableArrayList<?> EMPTY_ARRAY_LIST = new ImmutableArrayList(Collections.emptyList());
    private static final ImmutableHashSet<?> EMPTY_HASH_SET = new ImmutableHashSet(Collections.emptyList());
    private static final ImmutableHashMap<?, ?> EMPTY_HASH_MAP = new ImmutableHashMap(Collections.emptyMap());

    private Immutable() {
    }

    public static <T> ImmutableList<T> emptyList() {
        return EMPTY_ARRAY_LIST;
    }

    public static <T> ImmutableSet<T> emptySet() {
        return EMPTY_HASH_SET;
    }

    public static <K, V> ImmutableMap<K, V> emptyMap() {
        return EMPTY_HASH_MAP;
    }

    private static <T> ImmutableList<T> listOf(Iterable<T> elements, boolean needsCloning) {
        Objects.requireNonNull(elements);
        if (!elements.iterator().hasNext()) {
            return Immutable.emptyList();
        }
        return new ImmutableArrayList<T>(elements, needsCloning);
    }

    @SafeVarargs
    public static <T> ImmutableList<T> listOf(T ... elements) {
        return Immutable.listOf(Arrays.stream(elements).collect(Collectors.toList()), false);
    }

    public static <T> ImmutableList<T> listOf(Iterable<T> elements) {
        return Immutable.listOf(elements, true);
    }

    static <T> ImmutableList<T> listOfWithoutCloning(Iterable<T> elements) {
        return Immutable.listOf(elements, false);
    }

    private static <T> ImmutableSet<T> setOf(Iterable<T> elements, boolean needsCloning) {
        Objects.requireNonNull(elements);
        if (!elements.iterator().hasNext()) {
            return Immutable.emptySet();
        }
        return new ImmutableHashSet<T>(elements, needsCloning);
    }

    @SafeVarargs
    public static <T> ImmutableSet<T> setOf(T ... elements) {
        Objects.requireNonNull(elements);
        return Immutable.setOf(Arrays.stream(elements).collect(Collectors.toSet()), false);
    }

    public static <T> ImmutableSet<T> setOf(Iterable<T> elements) {
        return Immutable.setOf(elements, true);
    }

    static <T> ImmutableSet<T> setOfWithoutCloning(Iterable<T> elements) {
        return Immutable.setOf(elements, false);
    }

    public static <K, V> ImmutableMap<K, V> mapOf(Map<K, V> map) {
        Objects.requireNonNull(map);
        return new ImmutableHashMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> mapOf(Iterable<Pair<K, V>> pairs) {
        Objects.requireNonNull(pairs);
        if (!pairs.iterator().hasNext()) {
            return Immutable.emptyMap();
        }
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (Pair<K, V> p : pairs) {
            hashMap.put(p.getKey(), p.getValue());
        }
        return new ImmutableHashMap(hashMap, false);
    }

    public static <K, V> ImmutableMap<K, V> mapOf(K k, V v) {
        return Immutable.mapOf(Collections.singletonList(Pair.of(k, v)));
    }

    public static <K, V> ImmutableMap<K, V> mapOf(K k1, V v1, K k2, V v2) {
        return Immutable.mapOf(Arrays.asList(Pair.of(k1, v1), Pair.of(k2, v2)));
    }

    public static <K, V> ImmutableMap<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        return Immutable.mapOf(Arrays.asList(Pair.of(k1, v1), Pair.of(k2, v2), Pair.of(k3, v3)));
    }

    public static <K, V> ImmutableMap<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return Immutable.mapOf(Arrays.asList(Pair.of(k1, v1), Pair.of(k2, v2), Pair.of(k3, v3), Pair.of(k4, v4)));
    }

    public static <K, V> ImmutableMap<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return Immutable.mapOf(Arrays.asList(Pair.of(k1, v1), Pair.of(k2, v2), Pair.of(k3, v3), Pair.of(k4, v4), Pair.of(k5, v5)));
    }
}

