/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.ParallelStreaming;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.monad.Try;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;

public interface ImmutableCollection<T>
extends ParallelStreaming<T>,
Iterable<T> {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean contains(Object var1);

    default public boolean notContains(Object element) {
        return !this.contains(element);
    }

    default public boolean containsAll(Iterable<?> elements) {
        Objects.requireNonNull(elements);
        for (Object t : elements) {
            if (!this.notContains(t)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAny(Iterable<?> elements) {
        Objects.requireNonNull(elements);
        for (Object t : elements) {
            if (!this.contains(t)) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        for (Object t : this) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.stream().reduce(identity, accumulator);
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.stream().reduce(accumulator);
    }

    default public Optional<T> min(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return Try.of(() -> this.stream().min(comparator)).orElse(Optional.empty());
    }

    default public Optional<T> max(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return Try.of(() -> this.stream().max(comparator)).orElse(Optional.empty());
    }

    default public Optional<T> findFirst() {
        return this.isEmpty() ? Optional.empty() : Optional.ofNullable(this.iterator().next());
    }

    default public Optional<T> findFirst(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return Optional.ofNullable(t);
        }
        return Optional.empty();
    }

    public ImmutableList<T> toList();

    public ImmutableSet<T> toSet();

    default public List<T> toMutableList() {
        ArrayList arrayList = new ArrayList(this.size());
        for (Object t : this) {
            arrayList.add(t);
        }
        return arrayList;
    }

    default public Set<T> toMutableSet() {
        HashSet hashSet = new HashSet(this.size());
        for (Object t : this) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public int hashCode();

    public boolean equals(Object var1);
}

