/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.ImmutableArrayList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableCollection;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableHashMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableHashSet;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class ImmutableCollectors {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));

    private ImmutableCollectors() {
    }

    public static <T, C extends ImmutableCollection<T>> Collector<T, List<T>, C> toCollection(Function<List<T>, C> collectionFactory) {
        Objects.requireNonNull(collectionFactory);
        return Collector.of(ArrayList::new, List::add, (res1, res2) -> {
            res1.addAll(res2);
            return res1;
        }, collectionFactory, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, List<T>, ImmutableList<T>> toList() {
        return ImmutableCollectors.toCollection(list -> new ImmutableArrayList(list, false));
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toSet() {
        return ImmutableCollectors.toCollection(set -> new ImmutableHashSet(set, false));
    }

    public static <T, K, V> Collector<T, Map<K, V>, ImmutableMap<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        return Collector.of(HashMap::new, ImmutableCollectors.uniqKeysMapAccumulator(keyMapper, valueMapper), ImmutableCollectors.uniqKeysMapMerger(), map -> new ImmutableHashMap(map, false), new Collector.Characteristics[0]);
    }

    private static <T, K, V> BiConsumer<Map<K, V>, T> uniqKeysMapAccumulator(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return (map, element) -> {
            Object v;
            Object k = keyMapper.apply(element);
            Object u = map.putIfAbsent(k, v = Objects.requireNonNull(valueMapper.apply(element)));
            if (u != null) {
                throw ImmutableCollectors.duplicateKeyException(k, u, v);
            }
        };
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> uniqKeysMapMerger() {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                Object v;
                Object k = e.getKey();
                Object u = m1.putIfAbsent(k, v = Objects.requireNonNull(e.getValue()));
                if (u == null) continue;
                throw ImmutableCollectors.duplicateKeyException(k, u, v);
            }
            return m1;
        };
    }

    private static IllegalStateException duplicateKeyException(Object k, Object u, Object v) {
        return new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", k, u, v));
    }
}

