/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.Immutable;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableCollectionUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMapUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.Pair;
import com.github.simonharmonicminor.juu.lambda.TriFunction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ImmutableHashMap<K, V>
implements ImmutableMap<K, V>,
Serializable {
    private final HashMap<K, V> hashMap;
    private final ImmutableSet<K> keys;
    private final ImmutableList<V> values;
    private final ImmutableSet<Pair<K, V>> pairs;

    public ImmutableHashMap(Map<K, V> map) {
        this(map, true);
    }

    ImmutableHashMap(Map<K, V> map, boolean needsCloning) {
        this.hashMap = needsCloning || !(map instanceof HashMap) ? new HashMap<K, V>(map) : (HashMap)map;
        this.keys = Immutable.setOf(this.hashMap.keySet());
        this.values = Immutable.listOf(this.hashMap.values());
        this.pairs = ImmutableMapUtils.toPairSet(this.hashMap.entrySet());
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hashMap.containsValue(value);
    }

    @Override
    public boolean containsPair(Pair<K, V> pair) {
        Objects.requireNonNull(pair);
        return this.pairSet().contains(pair);
    }

    @Override
    public ImmutableMap<K, V> concatWithOverride(ImmutableMap<K, V> map) {
        Objects.requireNonNull(map);
        return ImmutableMapUtils.concatenationWithOverride(this.hashMap, map);
    }

    @Override
    public ImmutableMap<K, V> concatWithoutOverride(ImmutableMap<K, V> map) {
        Objects.requireNonNull(map);
        return ImmutableMapUtils.concatenationWithoutOverride(this.hashMap, map);
    }

    @Override
    public ImmutableMap<K, V> concatWith(ImmutableMap<K, V> map, TriFunction<K, V, V, V> overrideBehaviour) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(overrideBehaviour);
        return ImmutableMapUtils.concatenation(this.hashMap, map, overrideBehaviour);
    }

    @Override
    public V get(Object key) {
        return this.hashMap.get(key);
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.keys;
    }

    @Override
    public ImmutableList<V> values() {
        return this.values;
    }

    @Override
    public ImmutableSet<Pair<K, V>> pairSet() {
        return this.pairs;
    }

    @Override
    public Map<K, V> toMutableMap() {
        return new HashMap<K, V>(this.hashMap);
    }

    @Override
    public boolean equals(Object o) {
        return ImmutableCollectionUtils.mapEquals(this, o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hashMap);
    }
}

