/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.Immutable;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableHashMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableMap;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.Pair;
import com.github.simonharmonicminor.juu.lambda.TriFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class ImmutableMapUtils {
    private static final TriFunction<?, ?, ?, ?> KEEP_OLD = (key, oldVal, newVal) -> oldVal;
    private static final TriFunction<?, ?, ?, ?> KEEP_NEW = (key, oldVal, newVal) -> newVal;

    private ImmutableMapUtils() {
    }

    static <K, V> ImmutableSet<Pair<K, V>> toPairSet(Set<Map.Entry<K, V>> entrySet) {
        Objects.requireNonNull(entrySet);
        return Immutable.setOf(entrySet.stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList()));
    }

    static <K, V> ImmutableMap<K, V> concatenationWithOverride(Map<K, V> oldMutableMap, ImmutableMap<K, V> mapToConcat) {
        return ImmutableMapUtils.concatenation(oldMutableMap, mapToConcat, KEEP_NEW);
    }

    static <K, V> ImmutableMap<K, V> concatenationWithoutOverride(Map<K, V> oldMutableMap, ImmutableMap<K, V> mapToConcat) {
        return ImmutableMapUtils.concatenation(oldMutableMap, mapToConcat, KEEP_OLD);
    }

    static <K, V> ImmutableMap<K, V> concatenation(Map<K, V> oldMutableMap, ImmutableMap<K, V> mapToConcat, TriFunction<K, V, V, V> overrideBehaviour) {
        HashMap newHashMap = new HashMap(oldMutableMap);
        mapToConcat.forEach((k, v) -> {
            if (oldMutableMap.containsKey(k)) {
                newHashMap.put(k, overrideBehaviour.apply(k, oldMutableMap.get(k), v));
            } else {
                newHashMap.put(k, v);
            }
        });
        return new ImmutableHashMap<K, V>(newHashMap, false);
    }
}

