/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.collection.immutable;

import com.github.simonharmonicminor.juu.collection.immutable.Immutable;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableCollectionUtils;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableList;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableNavigableSet;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSet;
import com.github.simonharmonicminor.juu.collection.immutable.ImmutableSortedSet;
import com.github.simonharmonicminor.juu.collection.immutable.UnmodifiableIterator;
import com.github.simonharmonicminor.juu.monad.Try;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ImmutableTreeSet<T>
implements ImmutableNavigableSet<T>,
Serializable {
    private final TreeSet<T> treeSet;

    public static <R extends Comparable<R>> ImmutableTreeSet<R> of(Iterable<R> iterable) {
        Objects.requireNonNull(iterable);
        return new ImmutableTreeSet<R>(iterable, null);
    }

    public static <R> ImmutableTreeSet<R> ofSortedSet(SortedSet<R> sortedSet) {
        Objects.requireNonNull(sortedSet);
        return new ImmutableTreeSet<R>(sortedSet, true);
    }

    public static <R> ImmutableTreeSet<R> of(Iterable<R> iterable, Comparator<R> comparator) {
        Objects.requireNonNull(iterable);
        return new ImmutableTreeSet<R>(iterable, comparator);
    }

    ImmutableTreeSet(Iterable<T> iterable, Comparator<? super T> comparator) {
        Objects.requireNonNull(iterable);
        this.treeSet = new TreeSet<T>(comparator);
        for (T t : iterable) {
            this.treeSet.add(t);
        }
    }

    ImmutableTreeSet(SortedSet<T> sortedSet, boolean needsCloning) {
        this.treeSet = sortedSet instanceof TreeSet ? (needsCloning ? new TreeSet<T>(sortedSet) : (TreeSet)sortedSet) : new TreeSet<T>(sortedSet);
    }

    @Override
    public Optional<T> lower(T t) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeSet.lower(t));
    }

    @Override
    public Optional<T> floor(T t) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeSet.floor(t));
    }

    @Override
    public Optional<T> ceiling(T t) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeSet.ceiling(t));
    }

    @Override
    public Optional<T> higher(T t) {
        return ImmutableCollectionUtils.tryGetElement(() -> this.treeSet.higher(t));
    }

    @Override
    public ImmutableNavigableSet<T> reversedOrderSet() {
        return new ImmutableTreeSet<T>(this.treeSet.descendingSet(), false);
    }

    @Override
    public Iterator<T> reversedOrderIterator() {
        return new UnmodifiableIterator<T>(this.treeSet.descendingIterator());
    }

    private ImmutableNavigableSet<T> tryGetSubSet(Supplier<ImmutableNavigableSet<T>> supplier) {
        return Try.of(supplier::get).orElse(new ImmutableTreeSet(Immutable.emptyList(), this.treeSet.comparator()));
    }

    @Override
    public ImmutableNavigableSet<T> subSet(T fromElement, boolean fromInclusive, T toElement, boolean toInclusive) {
        return this.tryGetSubSet(() -> new ImmutableTreeSet<Object>(this.treeSet.subSet(fromElement, fromInclusive, toElement, toInclusive), false));
    }

    @Override
    public ImmutableNavigableSet<T> headSet(T toElement, boolean inclusive) {
        return this.tryGetSubSet(() -> new ImmutableTreeSet<Object>(this.treeSet.headSet(toElement, inclusive), false));
    }

    @Override
    public ImmutableNavigableSet<T> tailSet(T fromElement, boolean inclusive) {
        return this.tryGetSubSet(() -> new ImmutableTreeSet<Object>(this.treeSet.tailSet(fromElement, inclusive), false));
    }

    @Override
    public NavigableSet<T> toMutableNavigableSet() {
        return new TreeSet<T>(this.treeSet);
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.treeSet.comparator();
    }

    @Override
    public ImmutableSortedSet<T> subSet(T fromElement, T toElement) {
        return this.tryGetSubSet(() -> new ImmutableTreeSet<Object>(this.treeSet.subSet(fromElement, toElement), false));
    }

    @Override
    public ImmutableSortedSet<T> headSet(T toElement) {
        return this.tryGetSubSet(() -> new ImmutableTreeSet<Object>(this.treeSet.headSet(toElement), false));
    }

    @Override
    public ImmutableSortedSet<T> tailSet(T fromElement) {
        return this.tryGetSubSet(() -> new ImmutableTreeSet<Object>(this.treeSet.tailSet(fromElement), false));
    }

    @Override
    public Optional<T> first() {
        return ImmutableCollectionUtils.tryGetElement(this.treeSet::first);
    }

    @Override
    public Optional<T> last() {
        return ImmutableCollectionUtils.tryGetElement(this.treeSet::last);
    }

    @Override
    public SortedSet<T> toMutableSortedSet() {
        return this.toMutableNavigableSet();
    }

    @Override
    public ImmutableSet<T> concatWith(Iterable<T> iterable) {
        TreeSet<T> newTreeSet = new TreeSet<T>(this.treeSet);
        for (T t : iterable) {
            newTreeSet.add(t);
        }
        return new ImmutableTreeSet<T>(newTreeSet, false);
    }

    @Override
    public <R> ImmutableSet<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        HashSet<R> hashSet = new HashSet<R>(this.size());
        for (T t : this) {
            hashSet.add(mapper.apply(t));
        }
        return Immutable.setOfWithoutCloning(hashSet);
    }

    @Override
    public <R> ImmutableSet<R> flatMap(Function<? super T, ? extends Iterable<R>> mapper) {
        Objects.requireNonNull(mapper);
        HashSet<R> hashSet = new HashSet<R>();
        for (T t : this) {
            for (R r : mapper.apply(t)) {
                hashSet.add(r);
            }
        }
        return Immutable.setOfWithoutCloning(hashSet);
    }

    @Override
    public ImmutableSet<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        TreeSet<T> newTreeSet = new TreeSet<T>(this.comparator());
        for (T t : this) {
            if (!predicate.test(t)) continue;
            newTreeSet.add(t);
        }
        return new ImmutableTreeSet<T>(newTreeSet, false);
    }

    @Override
    public int size() {
        return this.treeSet.size();
    }

    @Override
    public boolean contains(Object element) {
        return Try.of(() -> this.treeSet.contains(element)).orElse(false);
    }

    @Override
    public ImmutableList<T> toList() {
        return Immutable.listOf(this.treeSet);
    }

    @Override
    public ImmutableSet<T> toSet() {
        return this;
    }

    @Override
    public Stream<T> parallelStream() {
        return this.treeSet.parallelStream();
    }

    @Override
    public Stream<T> stream() {
        return this.treeSet.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(this.treeSet.iterator());
    }

    @Override
    public boolean equals(Object o) {
        return ImmutableCollectionUtils.setEquals(this, o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treeSet);
    }

    public String toString() {
        return ImmutableCollectionUtils.setToString(this);
    }
}

