/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.measure;

import com.github.simonharmonicminor.juu.lambda.Action;
import com.github.simonharmonicminor.juu.measure.ExecutionResult;
import com.github.simonharmonicminor.juu.measure.MeasureConverter;
import com.github.simonharmonicminor.juu.measure.MeasureUnit;
import java.util.Objects;
import java.util.function.Supplier;

public class Measure<T> {
    private final Supplier<T> supplier;

    private Measure(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Measure<T> executionTime(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new Measure<T>(supplier);
    }

    public static Measure<Void> executionTime(Action action) {
        Objects.requireNonNull(action);
        return new Measure<Void>(() -> {
            action.execute();
            return null;
        });
    }

    public ExecutionResult<T> inMillis() {
        long time = System.currentTimeMillis();
        T result = this.supplier.get();
        return new ExecutionResult<T>(result, System.currentTimeMillis() - time, MeasureUnit.MILLIS);
    }

    public ExecutionResult<T> inNanos() {
        long time = System.nanoTime();
        T result = this.supplier.get();
        return new ExecutionResult<T>(result, System.nanoTime() - time, MeasureUnit.NANOS);
    }

    public ExecutionResult<T> inSeconds() {
        long start = System.currentTimeMillis();
        T result = this.supplier.get();
        long finish = System.currentTimeMillis();
        return new ExecutionResult<T>(result, MeasureConverter.millisToSeconds(finish - start), MeasureUnit.SECONDS);
    }
}

