/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.measure;

import com.github.simonharmonicminor.juu.measure.MeasureConverter;
import com.github.simonharmonicminor.juu.measure.MeasureUnit;
import java.util.function.Supplier;

public class Profiler {
    private static final long STILL_MEASURING = -1L;
    private final Supplier<Long> stopMeasuringSupplier;
    private final MeasureUnit measureUnit;
    private long measuringResult = -1L;

    public static Profiler startMeasuringInMillis() {
        long startPoint = System.currentTimeMillis();
        return new Profiler(() -> System.currentTimeMillis() - startPoint, MeasureUnit.MILLIS);
    }

    public static Profiler startMeasuringInNanos() {
        long startPoint = System.nanoTime();
        return new Profiler(() -> System.nanoTime() - startPoint, MeasureUnit.NANOS);
    }

    public static Profiler startMeasuringInSeconds() {
        long startPoint = System.currentTimeMillis();
        return new Profiler(() -> MeasureConverter.millisToSeconds(System.currentTimeMillis() - startPoint), MeasureUnit.SECONDS);
    }

    private Profiler(Supplier<Long> stopMeasuringSupplier, MeasureUnit measureUnit) {
        this.stopMeasuringSupplier = stopMeasuringSupplier;
        this.measureUnit = measureUnit;
    }

    public MeasureUnit getMeasureUnit() {
        return this.measureUnit;
    }

    public long stopMeasuring() {
        if (this.measuringResult == -1L) {
            this.measuringResult = this.stopMeasuringSupplier.get();
        }
        return this.measuringResult;
    }
}

