/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.monad;

import com.github.simonharmonicminor.juu.collection.Streaming;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Lazy<T>
implements Streaming<T> {
    private final Supplier<T> supplier;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(Objects.requireNonNull(supplier));
    }

    public <U> Lazy<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return Lazy.of(() -> mapper.apply((T)this.supplier.get()));
    }

    public <U> Lazy<U> flatMap(Function<? super T, ? extends Lazy<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return Lazy.of(() -> ((Lazy)mapper.apply((T)this.supplier.get())).calculate());
    }

    public T calculate() {
        return this.supplier.get();
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.calculate());
    }
}

