/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonharmonicminor.juu.monad;

import com.github.simonharmonicminor.juu.collection.Streaming;
import com.github.simonharmonicminor.juu.exception.EmptyContainerException;
import com.github.simonharmonicminor.juu.lambda.CheckedFunction;
import com.github.simonharmonicminor.juu.lambda.CheckedSupplier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Try<T>
implements Streaming<T> {
    private static final String CONTAINER_IS_EMPTY_MSG = "Container is empty";
    private static final Try<?> EMPTY = new Try<Object>(null, new EmptyContainerException("Container is empty", null));
    private final T value;
    private final Throwable reasonOfEmptiness;

    private Try(T value, Throwable reasonOfEmptiness) {
        this.value = value;
        this.reasonOfEmptiness = reasonOfEmptiness;
    }

    public static <T> Try<T> empty() {
        return EMPTY;
    }

    public static <T> Try<T> empty(Throwable reasonOfEmptiness) {
        Objects.requireNonNull(reasonOfEmptiness);
        return new Try<Object>(null, reasonOfEmptiness);
    }

    public static <T, E extends Throwable> Try<T> of(CheckedSupplier<T, E> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return new Try<T>(supplier.get(), null);
        }
        catch (Throwable e) {
            return Try.empty(e);
        }
    }

    public static <T, E extends Throwable> Try<T> getFirst(Iterable<CheckedSupplier<T, E>> suppliers) {
        Objects.requireNonNull(suppliers);
        for (CheckedSupplier<T, E> supplier : suppliers) {
            Try<T> t = Try.of(supplier);
            if (!t.isPresent()) continue;
            return t;
        }
        return Try.empty();
    }

    @SafeVarargs
    public static <T, E extends Throwable> Try<T> getFirst(CheckedSupplier<T, E> ... suppliers) {
        Objects.requireNonNull(suppliers);
        return Try.getFirst(Arrays.stream(suppliers).collect(Collectors.toList()));
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.reasonOfEmptiness != null;
    }

    public <U, E extends Throwable> Try<U> map(CheckedFunction<? super T, ? extends U, E> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Try.empty(this.reasonOfEmptiness);
        }
        return Try.of(() -> mapper.apply((T)this.value));
    }

    public <U, E extends Throwable> Try<U> flatMap(CheckedFunction<? super T, ? extends Try<? extends U>, E> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Try.empty(this.reasonOfEmptiness);
        }
        try {
            return mapper.apply(this.value);
        }
        catch (Throwable e) {
            return Try.empty(e);
        }
    }

    public Try<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return Try.empty(this.reasonOfEmptiness);
        }
        if (!predicate.test(this.value)) {
            return Try.empty(new EmptyContainerException(String.format("Predicate %s has returned false", predicate.toString())));
        }
        return this;
    }

    public T get() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new EmptyContainerException(CONTAINER_IS_EMPTY_MSG, this.reasonOfEmptiness);
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public <E extends Throwable> Try<T> orElseTry(CheckedSupplier<T, E> supplier) {
        Objects.requireNonNull(supplier);
        return this.isPresent() ? this : Try.of(supplier);
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseGet(Function<Throwable, ? extends T> reasonOfEmptinessProvider) {
        Objects.requireNonNull(reasonOfEmptinessProvider);
        return this.isPresent() ? this.value : reasonOfEmptinessProvider.apply(this.reasonOfEmptiness);
    }

    public <E extends Throwable> T orElseThrow(Supplier<? extends E> exceptionSupplier) throws E {
        Objects.requireNonNull(exceptionSupplier);
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public void ifPresent(Consumer<T> consumer) {
        Objects.requireNonNull(consumer);
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public void ifEmpty(Consumer<Throwable> reasonOfEmptinessProvider) {
        Objects.requireNonNull(reasonOfEmptinessProvider);
        if (this.isEmpty()) {
            reasonOfEmptinessProvider.accept(this.reasonOfEmptiness);
        }
    }

    public Optional<Throwable> getReasonOfEmptiness() {
        if (this.isEmpty()) {
            return Optional.ofNullable(this.reasonOfEmptiness);
        }
        return Optional.empty();
    }

    @Override
    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.value) : Stream.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Try aTry = (Try)o;
        return Objects.equals(this.value, aTry.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

