/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog;

import com.github.simonpercic.oklog.core.BaseLogDataInterceptor;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HttpEngine;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.Nullable;

class LogDataInterceptor
extends BaseLogDataInterceptor<Interceptor.Chain, Request, Response, Headers, MediaType> {
    private static final String OKHTTP_SENT_MILLIS = "OkHttp-Sent-Millis";
    private static final String OKHTTP_RECEIVED_MILLIS = "OkHttp-Received-Millis";

    LogDataInterceptor() {
    }

    protected Request request(Interceptor.Chain chain) {
        return chain.request();
    }

    protected String protocol(Interceptor.Chain chain) {
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.getProtocol() : Protocol.HTTP_1_1;
        return protocol.toString();
    }

    protected String requestMethod(Request request) {
        return request.method();
    }

    protected String requestUrl(Request request) {
        return request.httpUrl().toString();
    }

    protected String requestUrlPath(Request request) {
        return request.httpUrl().encodedPath();
    }

    protected String responseUrl(Response response) {
        return response.request().httpUrl().toString();
    }

    protected Headers requestHeaders(Request request) {
        return request.headers();
    }

    protected Headers responseHeaders(Response response) {
        return response.headers();
    }

    protected int headersCount(Headers headers) {
        return headers.size();
    }

    protected String headerName(Headers headers, int index) {
        return headers.name(index);
    }

    protected String headerValue(Headers headers, int index) {
        return headers.value(index);
    }

    protected String headerValue(Headers headers, String name) {
        return headers.get(name);
    }

    protected boolean hasRequestBody(Request request) {
        return request.body() != null;
    }

    protected boolean hasResponseBody(Response response) {
        return HttpEngine.hasBody((Response)response);
    }

    protected int responseCode(Response response) {
        return response.code();
    }

    protected String responseMessage(Response response) {
        return response.message();
    }

    protected long requestContentLength(Request request) throws IOException {
        return request.body().contentLength();
    }

    protected long responseContentLength(Response response) throws IOException {
        return response.body().contentLength();
    }

    protected MediaType requestContentType(Request request) {
        return request.body().contentType();
    }

    protected MediaType responseContentType(Response response) {
        return response.body().contentType();
    }

    protected String contentTypeString(MediaType mediaType) {
        return mediaType.toString();
    }

    protected Charset contentTypeCharset(MediaType mediaType, Charset charset) {
        return mediaType.charset(charset);
    }

    @Nullable
    protected Charset responseContentTypeCharset(MediaType contentType, Charset charset) {
        try {
            return this.contentTypeCharset(contentType, charset);
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    protected void writeRequestBody(Request request, Buffer buffer) throws IOException {
        request.body().writeTo((BufferedSink)buffer);
    }

    protected BufferedSource responseBodySource(Response response) throws IOException {
        return response.body().source();
    }

    protected boolean skipResponseHeader(String headerName) {
        return OKHTTP_SENT_MILLIS.equalsIgnoreCase(headerName) || OKHTTP_RECEIVED_MILLIS.equalsIgnoreCase(headerName);
    }
}

