/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu;

import com.github.smallmenu.FunBase;
import com.github.smallmenu.constant.RegexPattern;
import com.github.smallmenu.crypto.Hashids;
import com.github.smallmenu.date.Strtotime;
import com.github.smallmenu.expection.FunException;
import com.github.smallmenu.fun.ArrayFun;
import com.github.smallmenu.fun.CharFun;
import com.github.smallmenu.fun.DigestFun;
import com.github.smallmenu.fun.RandomFun;
import com.github.smallmenu.fun.StringFun;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Fun
extends FunBase {
    private Fun() {
        throw new AssertionError();
    }

    public static long time() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long microtime() {
        return System.currentTimeMillis();
    }

    public static long freeMemoryMb() {
        return Fun.freeMemory("MB");
    }

    public static long maxMemoryMb() {
        return Fun.maxMemory("MB");
    }

    public static long usedMemoryMb() {
        return Fun.usedMemory("MB");
    }

    public static long totalMemoryMb() {
        return Fun.totalMemory("MB");
    }

    public static byte[] bytes(CharSequence str) {
        return Fun.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return Fun.bytes(str, Fun.blank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static boolean empty(Object object) {
        if (object != null) {
            if (ArrayFun.isArray(object)) {
                return 0 == Array.getLength(object);
            }
            if (StringFun.isString(object)) {
                return object.toString().length() == 0;
            }
            if (object instanceof Integer) {
                return 0 == (Integer)object;
            }
            if (object instanceof Long) {
                return 0L == (Long)object;
            }
            if (object instanceof Short) {
                return 0 == (Short)object;
            }
            if (object instanceof Boolean) {
                return (Boolean)object == false;
            }
            return false;
        }
        return true;
    }

    public static boolean empty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static <T> boolean empty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean empty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean empty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean emptyAny(CharSequence ... strs) {
        if (Fun.empty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!Fun.empty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean emptyAll(CharSequence ... strs) {
        if (Fun.empty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (Fun.empty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean blank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharFun.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean blankAny(CharSequence ... strs) {
        if (Fun.empty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!Fun.blank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean blankAll(CharSequence ... strs) {
        if (Fun.empty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (Fun.blank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (Fun.empty(regex)) {
            return true;
        }
        return content.toString().matches(regex);
    }

    public static boolean matches(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String trim(CharSequence str) {
        return null == str ? null : StringFun.trim(str);
    }

    public static String ltrim(CharSequence str) {
        return null == str ? null : StringFun.trim(str, null, -1);
    }

    public static String rtrim(CharSequence str) {
        return null == str ? null : StringFun.trim(str, null, 1);
    }

    public static String trim(CharSequence str, CharSequence trimStr) {
        return null == str ? null : StringFun.trim(str, trimStr, 0);
    }

    public static String trimToEmpty(CharSequence str) {
        return str == null ? "" : Fun.trim(str);
    }

    public static String trimToDefault(CharSequence str, String defaultStr) {
        if (str == null) {
            return defaultStr;
        }
        String s = Fun.trim(str);
        return Fun.empty(s) ? defaultStr : s;
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = Fun.trim(str);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static int toInt(String str) {
        return Fun.toInt(Fun.toStr(str), 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return Fun.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return Fun.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return Fun.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().toLowerCase().contains(searchStr.toString().toLowerCase());
    }

    public static boolean containsAny(CharSequence str, CharSequence ... searchStrs) {
        if (Fun.empty(str) || Fun.empty(searchStrs)) {
            return false;
        }
        for (CharSequence checkStr : searchStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringFun.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringFun.equals(str1, str2, true);
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return StringFun.startsWith(str, prefix, false);
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return StringFun.startsWith(str, prefix, true);
    }

    public static boolean startsWithAny(CharSequence str, CharSequence ... searchStrings) {
        if (Fun.empty(str) || Fun.empty(searchStrings)) {
            return false;
        }
        for (CharSequence searchString : searchStrings) {
            if (!Fun.startsWith(str, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        return StringFun.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringFun.endsWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... searchStrings) {
        if (Fun.empty(str) || Fun.empty(searchStrings)) {
            return false;
        }
        for (CharSequence searchString : searchStrings) {
            if (!Fun.endsWith(str, searchString)) continue;
            return true;
        }
        return false;
    }

    public static int length(CharSequence str) {
        return str == null ? 0 : str.length();
    }

    public static String toLowerCase(CharSequence str) {
        return str == null ? null : str.toString().toLowerCase();
    }

    public static String toUpperCase(CharSequence str) {
        return str == null ? null : str.toString().toUpperCase();
    }

    public static String left(String str, int length) {
        if (str == null) {
            return null;
        }
        if (length < 0) {
            return "";
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static String right(String str, int length) {
        if (str == null) {
            return null;
        }
        if (length < 0) {
            return "";
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(str.length() - length);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringFun.indexOf(str, searchStr, 0, false);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int start) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringFun.indexOf(str, searchStr, start, false);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringFun.indexOf(str, searchStr, 0, true);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int start) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringFun.indexOf(str, searchStr, start, true);
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String toStr(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String toStr(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayFun.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String repeat(CharSequence str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return "";
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return Fun.toStr(str);
        }
        if (inputLength == 1 && repeat <= 8192) {
            return Fun.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return Fun.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String padLeft(CharSequence str, int length, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = length - str.length();
        if (pads <= 0) {
            return str.toString();
        }
        if (pads > 8192) {
            return Fun.padLeft(str, length, String.valueOf(padChar));
        }
        return Fun.repeat(padChar, pads).concat(str.toString());
    }

    public static String padLeft(CharSequence str, int length) {
        return Fun.padLeft(str, length, ' ');
    }

    public static String padLeft(CharSequence str, int length, String padStr) {
        if (str == null) {
            return null;
        }
        if (Fun.empty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = length - strLen;
        if (pads <= 0) {
            return Fun.toStr(str);
        }
        if (padLen == 1 && pads <= 8192) {
            return Fun.padLeft(str, length, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str.toString());
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str.toString());
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str.toString());
    }

    public static String padRight(CharSequence str, int length, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = length - str.length();
        if (pads <= 0) {
            return Fun.toStr(str);
        }
        if (pads > 8192) {
            return Fun.padRight(str, length, String.valueOf(padChar));
        }
        return str.toString().concat(Fun.repeat(padChar, pads));
    }

    public static String padRight(CharSequence str, int length) {
        return Fun.padRight(str, length, ' ');
    }

    public static String padRight(CharSequence str, int length, String padStr) {
        if (str == null) {
            return null;
        }
        if (Fun.empty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = length - strLen;
        if (pads <= 0) {
            return Fun.toStr(str);
        }
        if (padLen == 1 && pads <= 8192) {
            return Fun.padRight(str, length, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.toString().concat(padStr);
        }
        if (pads < padLen) {
            return str.toString().concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.toString().concat(new String(padding));
    }

    public static String[] split(CharSequence str) {
        if (str == null) {
            return ArrayFun.EMPTY_STRING;
        }
        return StringFun.split(str.toString(), 0, false, false);
    }

    public static String[] split(CharSequence str, char separator) {
        if (str == null) {
            return ArrayFun.EMPTY_STRING;
        }
        return StringFun.split(str.toString(), separator, 0, false, false, false);
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return ArrayFun.EMPTY_STRING;
        }
        if (separator == null) {
            return StringFun.split(str.toString(), 0, false, false);
        }
        return StringFun.split(str.toString(), separator.toString(), 0, false, false, false);
    }

    public static String[] splitTrim(CharSequence str) {
        if (str == null) {
            return ArrayFun.EMPTY_STRING;
        }
        return StringFun.split(str.toString(), 0, true, true);
    }

    public static String[] splitTrim(CharSequence str, char separator) {
        if (str == null) {
            return ArrayFun.EMPTY_STRING;
        }
        return StringFun.split(str.toString(), separator, 0, true, true, false);
    }

    public static String[] splitTrim(CharSequence str, CharSequence separator) {
        if (str == null) {
            return ArrayFun.EMPTY_STRING;
        }
        if (separator == null) {
            return StringFun.split(str.toString(), 0, true, true);
        }
        return StringFun.split(str.toString(), separator.toString(), 0, true, true, false);
    }

    public static List<String> splitToList(CharSequence str) {
        if (str == null) {
            return Collections.emptyList();
        }
        return StringFun.splitToList(str.toString(), 0, false, false);
    }

    public static List<String> splitToList(CharSequence str, char separator) {
        if (str == null) {
            return Collections.emptyList();
        }
        return StringFun.splitToList(str.toString(), separator, 0, false, false, false);
    }

    public static List<String> splitToList(CharSequence str, CharSequence separator) {
        if (str == null) {
            return Collections.emptyList();
        }
        if (separator == null) {
            return StringFun.splitToList(str.toString(), 0, false, false);
        }
        return StringFun.splitToList(str.toString(), separator.toString(), 0, false, false, false);
    }

    public static int[] splitTrimToInt(CharSequence str) {
        if (str == null) {
            return ArrayFun.EMPTY_INT;
        }
        String[] strings = StringFun.split(str.toString(), 0, true, true);
        return Arrays.stream(strings).mapToInt(Integer::parseInt).toArray();
    }

    public static int[] splitTrimToInt(CharSequence str, CharSequence separator) {
        if (str == null) {
            return ArrayFun.EMPTY_INT;
        }
        String[] strings = separator == null ? StringFun.split(str.toString(), 0, true, true) : StringFun.split(str.toString(), separator.toString(), 0, true, true, false);
        return ArrayFun.stringToIntArray(strings);
    }

    public static long[] splitTrimToLong(CharSequence str) {
        if (str == null) {
            return ArrayFun.EMPTY_LONG;
        }
        String[] strings = StringFun.split(str.toString(), 0, true, true);
        return Arrays.stream(strings).mapToLong(Long::parseLong).toArray();
    }

    public static long[] splitTrimToLong(CharSequence str, CharSequence separator) {
        if (str == null) {
            return ArrayFun.EMPTY_LONG;
        }
        String[] strings = separator == null ? StringFun.split(str.toString(), 0, true, true) : StringFun.split(str.toString(), separator.toString(), 0, true, true, false);
        return ArrayFun.stringToLongArray(strings);
    }

    public static List<String> splitTrimToList(CharSequence str) {
        if (str == null) {
            return Collections.emptyList();
        }
        return StringFun.splitToList(str.toString(), 0, true, true);
    }

    public static List<String> splitTrimToList(CharSequence str, char separator) {
        if (str == null) {
            return Collections.emptyList();
        }
        return StringFun.splitToList(str.toString(), separator, 0, true, true, false);
    }

    public static List<String> splitTrimToList(CharSequence str, CharSequence separator) {
        if (str == null) {
            return Collections.emptyList();
        }
        if (separator == null) {
            return StringFun.splitToList(str.toString(), 0, true, true);
        }
        return StringFun.splitToList(str.toString(), separator.toString(), 0, true, true, false);
    }

    public static String substring(CharSequence str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return "";
        }
        return str.toString().substring(start);
    }

    public static String substring(CharSequence str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.toString().substring(start, end);
    }

    public static String substr(CharSequence str, int start) {
        return Fun.substring(str, start);
    }

    public static String substr(CharSequence str, int start, int length) {
        int end;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (start < 0) {
            start = str.length() + start;
        }
        if (start > (end = length < 0 ? len + length : Math.min(start + length, len))) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.toString().substring(start, end);
    }

    public static <T> String join(T[] array, CharSequence separator) {
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (item == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(separator);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return Fun.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, "");
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        if (first != null) {
            sb.append(first);
            isFirst = false;
        }
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(separator);
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String regexMatch(Pattern pattern, CharSequence content, int groupIndex) {
        if (pattern == null || content == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static List<String> regexMatch(Pattern pattern, CharSequence content) {
        if (pattern == null || content == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            for (int i = 0; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String regexMatch(String regex, CharSequence content, int groupIndex) {
        if (regex == null || content == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return Fun.regexMatch(pattern, content, groupIndex);
    }

    public static List<String> regexMatch(String regex, CharSequence content) {
        if (regex == null || content == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return Fun.regexMatch(pattern, content);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replaceStr) {
        return StringFun.replace(str, searchStr, replaceStr, -1, false);
    }

    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replaceStr) {
        return StringFun.replace(str, searchStr, replaceStr, -1, true);
    }

    public static String remove(CharSequence str, CharSequence remove) {
        if (Fun.empty(str) || Fun.empty(remove)) {
            return Fun.toStr(str);
        }
        return str.toString().replace(remove, "");
    }

    public static String removePrefix(CharSequence str, CharSequence remove) {
        if (Fun.empty(str) || Fun.empty(remove)) {
            return Fun.toStr(str);
        }
        if (str.toString().startsWith(remove.toString())) {
            return str.toString().substring(remove.length());
        }
        return str.toString();
    }

    public static String removePrefixComplete(CharSequence str, CharSequence remove) {
        if (Fun.empty(str) || Fun.empty(remove)) {
            return Fun.toStr(str);
        }
        String removedStr = str.toString();
        while (removedStr.startsWith(remove.toString())) {
            removedStr = Fun.removePrefix(removedStr, remove);
        }
        return removedStr;
    }

    public static String removeSuffix(CharSequence str, CharSequence remove) {
        if (Fun.empty(str) || Fun.empty(remove)) {
            return Fun.toStr(str);
        }
        if (str.toString().endsWith(remove.toString())) {
            return str.toString().substring(0, str.length() - remove.length());
        }
        return str.toString();
    }

    public static String removeSuffixComplete(CharSequence str, CharSequence remove) {
        if (Fun.empty(str) || Fun.empty(remove)) {
            return Fun.toStr(str);
        }
        String removedStr = str.toString();
        while (removedStr.endsWith(remove.toString())) {
            removedStr = Fun.removeSuffix(removedStr, remove);
        }
        return removedStr;
    }

    public static String removeAny(CharSequence str, CharSequence ... removes) {
        String result = Fun.toStr(str);
        if (!Fun.empty(str)) {
            for (CharSequence remove : removes) {
                result = Fun.remove(result, remove);
            }
        }
        return result;
    }

    public static String removeAny(CharSequence str, char ... chars) {
        if (null == str || Fun.empty(chars)) {
            return Fun.toStr(str);
        }
        int len = str.length();
        if (0 == len) {
            return Fun.toStr(str);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayFun.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeLines(CharSequence str) {
        return Fun.removeAny(str, '\r', '\n');
    }

    public static String date() {
        return Fun.date("yyyy-MM-dd HH:mm:ss");
    }

    public static String date(long timestamp) {
        return Fun.date("yyyy-MM-dd HH:mm:ss", timestamp);
    }

    public static String date(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String date(String pattern, long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Math.abs(timestamp)), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static long strtotime() {
        return Instant.now().getEpochSecond();
    }

    public static long strtotime(String dateString) {
        return Strtotime.parse(dateString);
    }

    public static long strtotime(String expString, Long timestamp) {
        return Strtotime.parse(expString, timestamp);
    }

    public static int random() {
        return RandomFun.randomInt(Integer.MAX_VALUE);
    }

    public static int randomInt(int max) {
        return RandomFun.randomInt(max);
    }

    public static long randomLong(long max) {
        return RandomFun.randomLong(max);
    }

    public static String randomString(int length) {
        return RandomFun.randomString(length);
    }

    public static String randomStringExcepts(int length, String ... excepts) {
        return RandomFun.randomStringExcept(length, excepts);
    }

    public static String randomStringNumber(int length) {
        return RandomFun.randomStringNumber(length);
    }

    public static String randomStringChar(int length) {
        return RandomFun.randomStringChar(length);
    }

    public static String base64Encode(String str) {
        return Fun.base64Encode(Fun.bytes(str));
    }

    public static String base64Decode(String str) {
        return new String(Base64.getDecoder().decode(str));
    }

    public static String base64UrlSafeEncode(String str) {
        return Fun.base64UrlSafeEncode(Fun.bytes(str));
    }

    public static String base64UrlSafeDecode(String str) {
        return new String(Base64.getUrlDecoder().decode(str));
    }

    public static String md5(String str) {
        return DigestFun.md5Hex(str);
    }

    public static String sha1(String str) {
        return DigestFun.sha1Hex(str);
    }

    public static String sha256(String str) {
        return DigestFun.sha256Hex(str);
    }

    public static String sha384(String str) {
        return DigestFun.sha384Hex(str);
    }

    public static String sha512(String str) {
        return DigestFun.sha512Hex(str);
    }

    public static String idEncode(long id) {
        Hashids hashids = new Hashids();
        return hashids.encode(id);
    }

    public static String idEncode(long id, int minLength) {
        Hashids hashids = new Hashids(minLength);
        return hashids.encode(id);
    }

    public static String idEncode(long id, String salt) {
        Hashids hashids = new Hashids(salt);
        return hashids.encode(id);
    }

    public static String idEncode(long id, String salt, int minLength) {
        Hashids hashids = new Hashids(salt, minLength);
        return hashids.encode(id);
    }

    public static long idDecode(String hash) {
        Hashids hashids = new Hashids();
        long[] ids = hashids.decode(hash);
        if (!Fun.empty(ids)) {
            return ids[0];
        }
        return 0L;
    }

    public static long idDecode(String hash, int minLength) {
        Hashids hashids = new Hashids(minLength);
        long[] ids = hashids.decode(hash);
        if (!Fun.empty(ids)) {
            return ids[0];
        }
        return 0L;
    }

    public static long idDecode(String hash, String salt) {
        Hashids hashids = new Hashids(salt);
        long[] ids = hashids.decode(hash);
        if (!Fun.empty(ids)) {
            return ids[0];
        }
        return 0L;
    }

    public static long idDecode(String hash, String salt, int minLength) {
        Hashids hashids = new Hashids(salt, minLength);
        long[] ids = hashids.decode(hash);
        if (!Fun.empty(ids)) {
            return ids[0];
        }
        return 0L;
    }

    public static URL urlParse(String url) {
        String formatUrl = Fun.urlNormalize(url);
        if (!Fun.empty(formatUrl)) {
            try {
                return new URL(formatUrl);
            }
            catch (MalformedURLException e) {
                throw new FunException(e);
            }
        }
        return null;
    }

    public static boolean urlVerify(String url) {
        if (!Fun.blank(url)) {
            return Fun.matches(RegexPattern.URL_HTTP, (CharSequence)url);
        }
        return false;
    }

    public static String urlNormalize(String url) {
        if (Fun.urlVerify(url)) {
            if (Fun.startsWith(url, "//")) {
                String formatUrl = Fun.removePrefix(url, "//");
                return "http://" + formatUrl;
            }
            if (!Fun.contains(url, "://")) {
                return "http://" + url;
            }
            return url;
        }
        return "";
    }
}

