/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.producer;

import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.producer.MessageWriter;
import com.github.sonus21.rqueue.utils.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;

public class RqueueMessageSender {
    private MessageWriter messageWriter;
    private RqueueMessageTemplate messageTemplate;

    private List<MessageConverter> getMessageConverters(boolean addDefault, List<MessageConverter> messageConverters) {
        ArrayList<MessageConverter> messageConverterList = new ArrayList<MessageConverter>();
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        messageConverterList.add((MessageConverter)stringMessageConverter);
        if (addDefault) {
            messageConverterList.add(new GenericMessageConverter());
        }
        messageConverterList.addAll(messageConverters);
        return messageConverterList;
    }

    private RqueueMessageSender(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters, boolean addDefault) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate can not be null");
        Assert.notEmpty(messageConverters, (String)"messageConverters can  not be empty");
        this.messageTemplate = messageTemplate;
        this.messageWriter = new MessageWriter(messageTemplate, this.getMessageConverters(addDefault, messageConverters));
    }

    public RqueueMessageSender(RqueueMessageTemplate messageTemplate) {
        this(messageTemplate, Collections.singletonList(new GenericMessageConverter()), false);
    }

    public RqueueMessageSender(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters) {
        this(messageTemplate, messageConverters, true);
    }

    public boolean put(String queueName, Object message) {
        Validator.validateQueueNameAndMessage(queueName, message);
        return this.messageWriter.pushMessage(queueName, message, null, null);
    }

    public boolean put(String queueName, Object message, int retryCount) {
        Validator.validateQueueNameAndMessage(queueName, message);
        Validator.validateRetryCount(retryCount);
        return this.messageWriter.pushMessage(queueName, message, retryCount, null);
    }

    public boolean put(String queueName, Object message, long delayInMilliSecs) {
        Validator.validateQueueNameAndMessage(queueName, message);
        Validator.validateDelay(delayInMilliSecs);
        return this.messageWriter.pushMessage(queueName, message, null, delayInMilliSecs);
    }

    public List<Object> getAllMessages(String queueName) {
        ArrayList<Object> messages = new ArrayList<Object>();
        for (RqueueMessage message : this.messageTemplate.getAllMessages(queueName)) {
            messages.add(this.messageWriter.convertMessageToObject(message));
        }
        return messages;
    }

    public boolean put(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueueNameAndMessage(queueName, message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.messageWriter.pushMessage(queueName, message, retryCount, delayInMilliSecs);
    }

    public List<MessageConverter> getMessageConverters() {
        return this.messageWriter.getMessageConverters();
    }
}

