/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class RqueueConfig {
    private final RedisConnectionFactory connectionFactory;
    private final boolean sharedConnection;
    private final int dbVersion;
    @Value(value="${rqueue.version:2.0.1}")
    private String version;
    @Value(value="${rqueue.key.prefix:__rq::}")
    private String prefix;
    @Value(value="${rqueue.cluster.mode:true}")
    private boolean clusterMode;
    @Value(value="${rqueue.simple.queue.prefix:queue::}")
    private String simpleQueuePrefix;
    @Value(value="${rqueue.delayed.queue.prefix:d-queue::}")
    private String delayedQueuePrefix;
    @Value(value="${rqueue.delayed.queue.channel.prefix:d-channel::}")
    private String delayedQueueChannelPrefix;
    @Value(value="${rqueue.processing.queue.name.prefix:p-queue::}")
    private String processingQueuePrefix;
    @Value(value="${rqueue.processing.queue.channel.prefix:p-channel::}")
    private String processingQueueChannelPrefix;
    @Value(value="${rqueue.queues.key.suffix:queues}")
    private String queuesKeySuffix;
    @Value(value="${rqueue.lock.key.prefix:lock::}")
    private String lockKeyPrefix;
    @Value(value="${rqueue.queue.stat.key.prefix:q-stat::}")
    private String queueStatKeyPrefix;
    @Value(value="${rqueue.queue.config.key.prefix:q-config::}")
    private String queueConfigKeyPrefix;
    @Value(value="${rqueue.retry.per.poll:1}")
    private int retryPerPoll;
    @Value(value="${rqueue.add.default.queue.with.queue.level.priority:true}")
    private boolean addDefaultQueueWithQueueLevelPriority;
    @Value(value="${rqueue.default.queue.with.queue.level.priority:-1}")
    private int defaultQueueWithQueueLevelPriority;

    public String getQueuesKey() {
        return this.prefix + this.queuesKeySuffix;
    }

    public String getQueueName(String queueName) {
        if (this.dbVersion >= 2) {
            return this.prefix + this.simpleQueuePrefix + this.getTaggedName(queueName);
        }
        return queueName;
    }

    public String getDelayedQueueName(String queueName) {
        if (this.dbVersion >= 2) {
            return this.prefix + this.delayedQueuePrefix + this.getTaggedName(queueName);
        }
        return "rqueue-delay::" + queueName;
    }

    public String getDelayedQueueChannelName(String queueName) {
        if (this.dbVersion >= 2) {
            return this.prefix + this.delayedQueueChannelPrefix + this.getTaggedName(queueName);
        }
        return "rqueue-channel::" + queueName;
    }

    public String getProcessingQueueName(String queueName) {
        if (this.dbVersion >= 2) {
            return this.prefix + this.processingQueuePrefix + this.getTaggedName(queueName);
        }
        return "rqueue-processing::" + queueName;
    }

    public String getProcessingQueueChannelName(String queueName) {
        if (this.dbVersion >= 2) {
            return this.prefix + this.processingQueueChannelPrefix + this.getTaggedName(queueName);
        }
        return "rqueue-processing-channel::" + queueName;
    }

    public String getLockKey(String key) {
        return this.prefix + this.lockKeyPrefix + key;
    }

    public String getQueueStatisticsKey(String name) {
        return this.prefix + this.queueStatKeyPrefix + name;
    }

    public String getQueueConfigKey(String name) {
        return this.prefix + this.queueConfigKeyPrefix + name;
    }

    private String getTaggedName(String queueName) {
        if (!this.clusterMode) {
            return queueName;
        }
        return "{" + queueName + "}";
    }

    @Generated
    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Generated
    public boolean isSharedConnection() {
        return this.sharedConnection;
    }

    @Generated
    public int getDbVersion() {
        return this.dbVersion;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public boolean isClusterMode() {
        return this.clusterMode;
    }

    @Generated
    public String getSimpleQueuePrefix() {
        return this.simpleQueuePrefix;
    }

    @Generated
    public String getDelayedQueuePrefix() {
        return this.delayedQueuePrefix;
    }

    @Generated
    public String getDelayedQueueChannelPrefix() {
        return this.delayedQueueChannelPrefix;
    }

    @Generated
    public String getProcessingQueuePrefix() {
        return this.processingQueuePrefix;
    }

    @Generated
    public String getProcessingQueueChannelPrefix() {
        return this.processingQueueChannelPrefix;
    }

    @Generated
    public String getQueuesKeySuffix() {
        return this.queuesKeySuffix;
    }

    @Generated
    public String getLockKeyPrefix() {
        return this.lockKeyPrefix;
    }

    @Generated
    public String getQueueStatKeyPrefix() {
        return this.queueStatKeyPrefix;
    }

    @Generated
    public String getQueueConfigKeyPrefix() {
        return this.queueConfigKeyPrefix;
    }

    @Generated
    public int getRetryPerPoll() {
        return this.retryPerPoll;
    }

    @Generated
    public boolean isAddDefaultQueueWithQueueLevelPriority() {
        return this.addDefaultQueueWithQueueLevelPriority;
    }

    @Generated
    public int getDefaultQueueWithQueueLevelPriority() {
        return this.defaultQueueWithQueueLevelPriority;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
    }

    @Generated
    public void setSimpleQueuePrefix(String simpleQueuePrefix) {
        this.simpleQueuePrefix = simpleQueuePrefix;
    }

    @Generated
    public void setDelayedQueuePrefix(String delayedQueuePrefix) {
        this.delayedQueuePrefix = delayedQueuePrefix;
    }

    @Generated
    public void setDelayedQueueChannelPrefix(String delayedQueueChannelPrefix) {
        this.delayedQueueChannelPrefix = delayedQueueChannelPrefix;
    }

    @Generated
    public void setProcessingQueuePrefix(String processingQueuePrefix) {
        this.processingQueuePrefix = processingQueuePrefix;
    }

    @Generated
    public void setProcessingQueueChannelPrefix(String processingQueueChannelPrefix) {
        this.processingQueueChannelPrefix = processingQueueChannelPrefix;
    }

    @Generated
    public void setQueuesKeySuffix(String queuesKeySuffix) {
        this.queuesKeySuffix = queuesKeySuffix;
    }

    @Generated
    public void setLockKeyPrefix(String lockKeyPrefix) {
        this.lockKeyPrefix = lockKeyPrefix;
    }

    @Generated
    public void setQueueStatKeyPrefix(String queueStatKeyPrefix) {
        this.queueStatKeyPrefix = queueStatKeyPrefix;
    }

    @Generated
    public void setQueueConfigKeyPrefix(String queueConfigKeyPrefix) {
        this.queueConfigKeyPrefix = queueConfigKeyPrefix;
    }

    @Generated
    public void setRetryPerPoll(int retryPerPoll) {
        this.retryPerPoll = retryPerPoll;
    }

    @Generated
    public void setAddDefaultQueueWithQueueLevelPriority(boolean addDefaultQueueWithQueueLevelPriority) {
        this.addDefaultQueueWithQueueLevelPriority = addDefaultQueueWithQueueLevelPriority;
    }

    @Generated
    public void setDefaultQueueWithQueueLevelPriority(int defaultQueueWithQueueLevelPriority) {
        this.defaultQueueWithQueueLevelPriority = defaultQueueWithQueueLevelPriority;
    }

    @Generated
    public RqueueConfig(RedisConnectionFactory connectionFactory, boolean sharedConnection, int dbVersion) {
        this.connectionFactory = connectionFactory;
        this.sharedConnection = sharedConnection;
        this.dbVersion = dbVersion;
    }
}

