/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.models.SerializableBase;
import java.util.UUID;
import lombok.Generated;

public class RqueueMessage
extends SerializableBase
implements Cloneable {
    private static final long serialVersionUID = -3488860960637488519L;
    private String id;
    private String queueName;
    private String message;
    private Integer retryCount;
    private long queuedTime;
    private long processAt;
    private Long reEnqueuedAt;
    private int failureCount;

    public RqueueMessage(String queueName, String message, Integer retryCount, Long delay) {
        this.queueName = queueName;
        this.message = message;
        this.retryCount = retryCount;
        this.queuedTime = System.currentTimeMillis();
        this.id = UUID.randomUUID().toString();
        this.processAt = this.queuedTime;
        if (delay != null) {
            this.processAt += delay.longValue();
        }
    }

    public void updateReEnqueuedAt() {
        this.reEnqueuedAt = System.currentTimeMillis();
    }

    public RqueueMessage clone() throws CloneNotSupportedException {
        return (RqueueMessage)super.clone();
    }

    public boolean equals(Object other) {
        RqueueMessage otherMessage;
        if (other instanceof RqueueMessage && (otherMessage = (RqueueMessage)other).getId() != null && this.getId() != null) {
            return this.getId().equals(otherMessage.getId());
        }
        return false;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Integer getRetryCount() {
        return this.retryCount;
    }

    @Generated
    public long getQueuedTime() {
        return this.queuedTime;
    }

    @Generated
    public long getProcessAt() {
        return this.processAt;
    }

    @Generated
    public Long getReEnqueuedAt() {
        return this.reEnqueuedAt;
    }

    @Generated
    public int getFailureCount() {
        return this.failureCount;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    @Generated
    public void setQueuedTime(long queuedTime) {
        this.queuedTime = queuedTime;
    }

    @Generated
    public void setProcessAt(long processAt) {
        this.processAt = processAt;
    }

    @Generated
    public void setReEnqueuedAt(Long reEnqueuedAt) {
        this.reEnqueuedAt = reEnqueuedAt;
    }

    @Generated
    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    @Generated
    public String toString() {
        return "RqueueMessage(id=" + this.getId() + ", queueName=" + this.getQueueName() + ", message=" + this.getMessage() + ", retryCount=" + this.getRetryCount() + ", queuedTime=" + this.getQueuedTime() + ", processAt=" + this.getProcessAt() + ", reEnqueuedAt=" + this.getReEnqueuedAt() + ", failureCount=" + this.getFailureCount() + ")";
    }

    @Generated
    public RqueueMessage() {
    }
}

