/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueSchedulerConfig;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class RqueueRedisListenerContainerFactory
implements DisposableBean,
SmartLifecycle,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueRedisListenerContainerFactory.class);
    @Autowired
    private RqueueSchedulerConfig rqueueSchedulerConfig;
    @Autowired
    private RqueueConfig rqueueConfig;
    @Autowired(required=false)
    private RedisMessageListenerContainer systemContainer;
    private RedisMessageListenerContainer container;
    private boolean sharedContainer = false;

    public void destroy() throws Exception {
        if (this.isMyContainer()) {
            this.container.destroy();
        }
    }

    public void start() {
        if (this.isMyContainer()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.isMyContainer()) {
            this.container.stop();
        }
    }

    public boolean isRunning() {
        if (this.container != null) {
            return this.container.isRunning();
        }
        return false;
    }

    public RedisMessageListenerContainer getContainer() {
        return this.container;
    }

    private boolean isMyContainer() {
        return this.container != null && !this.sharedContainer;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.rqueueSchedulerConfig.isRedisEnabled()) {
            return;
        }
        if ((this.rqueueConfig.isSharedConnection() || this.rqueueSchedulerConfig.isListenerShared()) && this.systemContainer != null) {
            this.container = this.systemContainer;
            this.sharedContainer = true;
            return;
        }
        this.container = new RedisMessageListenerContainer();
        this.container.setConnectionFactory(this.rqueueConfig.getConnectionFactory());
        this.container.afterPropertiesSet();
    }
}

