/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.converter.RqueueRedisSerializer;
import com.github.sonus21.rqueue.utils.SerializationUtils;
import java.util.List;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisUtils {
    private RedisUtils() {
    }

    public static <V> RedisTemplate<String, V> getRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        RqueueRedisSerializer rqueueRedisSerializer = new RqueueRedisSerializer();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)rqueueRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)rqueueRedisSerializer);
        return redisTemplate;
    }

    public static <V> List<Object> executePipeLine(RedisTemplate<String, V> template, RedisPipelineCallback callback) {
        return template.executePipelined(connection -> {
            RqueueRedisSerializer valueSerializer = (RqueueRedisSerializer)template.getValueSerializer();
            StringRedisSerializer keySerializer = (StringRedisSerializer)template.getKeySerializer();
            callback.doInRedis(connection, keySerializer, valueSerializer);
            return null;
        });
    }

    public static void setVersion(RedisConnectionFactory connectionFactory, String versionKey, int version) {
        RedisConnection connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)connectionFactory);
        byte[] versionKeyBytes = versionKey.getBytes();
        connection.set(versionKeyBytes, String.valueOf(version).getBytes());
    }

    public static int updateAndGetVersion(RedisConnectionFactory redisConnectionFactory, String versionDbKey, int defaultVersion) {
        byte[] versionKey;
        RedisConnection connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)redisConnectionFactory);
        byte[] versionFromDb = connection.get(versionKey = versionDbKey.getBytes());
        if (SerializationUtils.isEmpty(versionFromDb)) {
            Long count = (Long)connection.eval("return #redis.pcall('keys', 'rqueue-*')".getBytes(), ReturnType.INTEGER, 0, (byte[][])new byte[0][]);
            if (count != null && count > 0L) {
                int version = 1;
                connection.set(versionKey, String.valueOf(version).getBytes());
                return version;
            }
            connection.set(versionKey, String.valueOf(defaultVersion).getBytes());
            return defaultVersion;
        }
        return Integer.parseInt(new String(versionFromDb));
    }

    public static interface RedisPipelineCallback {
        public void doInRedis(RedisConnection var1, StringRedisSerializer var2, RqueueRedisSerializer var3);
    }
}

