/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import java.beans.Introspector;

public class StringUtils {
    StringUtils() {
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.isEmpty();
    }

    public static String clean(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static boolean isAlpha(Character c) {
        return Character.isUpperCase(c.charValue()) || Character.isLowerCase(c.charValue());
    }

    public static String getBeanName(String queueName) {
        return StringUtils.convertToCamelCase(queueName);
    }

    public static String convertToCamelCase(String string) {
        String txt = StringUtils.clean(string);
        if (StringUtils.isEmpty(txt)) {
            throw new IllegalArgumentException("string is empty");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (!StringUtils.isAlpha(Character.valueOf(c))) continue;
            if (i == 0) {
                sb.append(c);
                continue;
            }
            if (!StringUtils.isAlpha(Character.valueOf(txt.charAt(i - 1)))) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isLowerCase(c) || Character.isUpperCase(c) && Character.isLowerCase(txt.charAt(i - 1))) {
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        String convertedTxt = sb.toString();
        if (convertedTxt.isEmpty()) {
            return txt;
        }
        return Introspector.decapitalize(convertedTxt);
    }

    public static String groupName(String name) {
        String groupName = StringUtils.convertToCamelCase(name);
        if (StringUtils.isAlpha(Character.valueOf(groupName.charAt(0))) && Character.isLowerCase(groupName.charAt(0))) {
            char[] chars = groupName.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return groupName;
    }
}

