/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.QueueRegistry;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.event.RqueueBootstrapEvent;
import com.github.sonus21.rqueue.models.response.BaseResponse;
import com.github.sonus21.rqueue.utils.RedisUtils;
import com.github.sonus21.rqueue.web.dao.RqueueSystemConfigDao;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RqueueSystemManagerServiceImpl
implements RqueueSystemManagerService {
    private final RqueueConfig rqueueConfig;
    private final RqueueRedisTemplate<String> stringRqueueRedisTemplate;
    private final RqueueSystemConfigDao rqueueSystemConfigDao;

    @Autowired
    public RqueueSystemManagerServiceImpl(RqueueConfig rqueueConfig, RqueueRedisTemplate<String> stringRqueueRedisTemplate, RqueueSystemConfigDao rqueueSystemConfigDao) {
        this.rqueueConfig = rqueueConfig;
        this.stringRqueueRedisTemplate = stringRqueueRedisTemplate;
        this.rqueueSystemConfigDao = rqueueSystemConfigDao;
    }

    private List<String> queueKeys(QueueConfig queueConfig) {
        ArrayList keys = Lists.newArrayList((Object[])new String[]{queueConfig.getQueueName(), queueConfig.getProcessingQueueName(), this.rqueueConfig.getQueueStatisticsKey(queueConfig.getName())});
        keys.add(queueConfig.getDelayedQueueName());
        if (queueConfig.hasDeadLetterQueue()) {
            keys.addAll(queueConfig.getDeadLetterQueues());
        }
        return keys;
    }

    @Override
    public BaseResponse deleteQueue(String queueName) {
        QueueConfig queueConfig = this.rqueueSystemConfigDao.getQConfig(this.rqueueConfig.getQueueConfigKey(queueName));
        BaseResponse baseResponse = new BaseResponse();
        if (queueConfig == null) {
            baseResponse.setCode(1);
            baseResponse.setMessage("Queue not found");
            return baseResponse;
        }
        queueConfig.setDeletedOn(System.currentTimeMillis());
        queueConfig.setDeleted(true);
        RedisUtils.executePipeLine(this.stringRqueueRedisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
            for (String key : this.queueKeys(queueConfig)) {
                connection.del((byte[][])new byte[][]{key.getBytes()});
            }
            connection.set(queueConfig.getId().getBytes(), valueSerializer.serialize(queueConfig));
        });
        baseResponse.setCode(0);
        baseResponse.setMessage("Queue deleted");
        return baseResponse;
    }

    private QueueConfig createOrUpdateConfig(QueueConfig queueConfig, QueueDetail queueDetail) {
        String qConfigId = this.rqueueConfig.getQueueConfigKey(queueDetail.getName());
        QueueConfig systemQueueConfig = queueConfig;
        boolean updated = false;
        boolean created = false;
        if (systemQueueConfig == null) {
            created = true;
            systemQueueConfig = queueDetail.toConfig();
            systemQueueConfig.setId(qConfigId);
        }
        if (queueDetail.isDlqSet()) {
            updated = systemQueueConfig.addDeadLetterQueue(queueDetail.getDeadLetterQueueName());
        }
        updated = systemQueueConfig.updateVisibilityTimeout(queueDetail.getVisibilityTimeout()) || updated;
        updated = systemQueueConfig.updateConcurrency(queueDetail.getConcurrency().toMinMax()) || updated;
        updated = systemQueueConfig.updateRetryCount(queueDetail.getNumRetry()) || updated;
        updated = systemQueueConfig.updatePriorityGroup(queueDetail.getPriorityGroup()) || updated;
        boolean bl = updated = systemQueueConfig.updatePriority(queueDetail.getPriority()) || updated;
        if (updated && !created) {
            systemQueueConfig.updateTime();
        }
        if (updated || created) {
            return systemQueueConfig;
        }
        return null;
    }

    private void createOrUpdateConfigs(List<QueueDetail> queueDetails) {
        String[] queues = new String[queueDetails.size()];
        int i = 0;
        for (QueueDetail queueDetail : queueDetails) {
            queues[i++] = queueDetail.getName();
        }
        this.stringRqueueRedisTemplate.addToSet(this.rqueueConfig.getQueuesKey(), (Serializable[])queues);
        List<String> ids = Arrays.stream(queues).map(this.rqueueConfig::getQueueConfigKey).collect(Collectors.toList());
        List<QueueConfig> queueConfigs = this.rqueueSystemConfigDao.findAllQConfig(ids);
        ArrayList<QueueConfig> newConfigs = new ArrayList<QueueConfig>();
        for (QueueDetail queueDetail : queueDetails) {
            QueueConfig newConfig;
            QueueConfig dbConfig = null;
            for (QueueConfig queueConfig : queueConfigs) {
                if (!queueConfig.getQueueName().equals(queueDetail.getQueueName())) continue;
                dbConfig = queueConfig;
                break;
            }
            if ((newConfig = this.createOrUpdateConfig(dbConfig, queueDetail)) == null) continue;
            newConfigs.add(newConfig);
        }
        if (!CollectionUtils.isEmpty(newConfigs)) {
            this.rqueueSystemConfigDao.saveAllQConfig(newConfigs);
        }
    }

    @Async
    public void onApplicationEvent(RqueueBootstrapEvent event) {
        if (event.isStart()) {
            List<QueueDetail> queueDetails = QueueRegistry.getActiveQueueDetails();
            if (queueDetails.isEmpty()) {
                return;
            }
            this.createOrUpdateConfigs(queueDetails);
        }
    }

    @Override
    public List<String> getQueues() {
        Set<String> members = this.stringRqueueRedisTemplate.getMembers(this.rqueueConfig.getQueuesKey());
        if (CollectionUtils.isEmpty(members)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(members);
    }

    @Override
    public List<QueueConfig> getQueueConfigs(Collection<String> queues) {
        Collection<String> ids = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(queues)) {
            ids = queues.stream().map(this.rqueueConfig::getQueueConfigKey).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(ids)) {
            return this.rqueueSystemConfigDao.findAllQConfig(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public List<QueueConfig> getQueueConfigs() {
        List<String> queues = this.getQueues();
        return this.getQueueConfigs(queues);
    }

    @Override
    public List<QueueConfig> getSortedQueueConfigs() {
        List<String> queues = this.getQueues();
        return this.getQueueConfigs(queues).stream().sorted(Comparator.comparing(QueueConfig::getName)).collect(Collectors.toList());
    }

    @Override
    public QueueConfig getQueueConfig(String queueName) {
        List<QueueConfig> queueConfigs = this.getQueueConfigs(Collections.singletonList(queueName));
        if (CollectionUtils.isEmpty(queueConfigs)) {
            return null;
        }
        return queueConfigs.get(0);
    }
}

