/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils;

import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;

public class SpringContextUtils {
    public static ApplicationContext contextMergedBeans(String xmlPath, Map<String, ?> extraBeans) {
        DefaultListableBeanFactory parentBeanFactory = SpringContextUtils.buildListableBeanFactory(extraBeans);
        GenericApplicationContext parentContext = new GenericApplicationContext(parentBeanFactory);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)parentContext);
        xmlReader.loadBeanDefinitions(xmlPath);
        parentContext.refresh();
        return parentContext;
    }

    public static ApplicationContext contextMergedBeans(Map<String, ?> extraBeans, Class<?> config) {
        DefaultListableBeanFactory parentBeanFactory = SpringContextUtils.buildListableBeanFactory(extraBeans);
        GenericApplicationContext parentContext = new GenericApplicationContext(parentBeanFactory);
        AnnotatedBeanDefinitionReader annotationReader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)parentContext);
        annotationReader.registerBean(config);
        parentContext.refresh();
        return parentContext;
    }

    private static DefaultListableBeanFactory buildListableBeanFactory(Map<String, ?> extraBeans) {
        DefaultListableBeanFactory parentBeanFactory = new DefaultListableBeanFactory();
        for (String key : extraBeans.keySet()) {
            parentBeanFactory.registerSingleton(key, extraBeans.get(key));
        }
        return parentBeanFactory;
    }
}

