/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.jdbc;

import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SpartaJdbcTemplate
extends JdbcTemplate {
    public SpartaJdbcTemplate() {
    }

    public SpartaJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public SpartaJdbcTemplate(DataSource dataSource, boolean lazyInit) {
        super(dataSource, lazyInit);
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Class<T> requiredType) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, requiredType);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, requiredType, args);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, args, requiredType);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Object[] args, int[] argTypes, Class<T> requiredType) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, args, argTypes, requiredType);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, args, argTypes, rowMapper);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, args, rowMapper);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, rowMapper);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, rowMapper, args);
            result = Optional.ofNullable(obj);
        }
        catch (EmptyResultDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }
}

