/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.queryloader.impl;

import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sparta.springwebutils.queryloader.QueryLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FileQueryLoader
implements QueryLoader,
InitializingBean {
    private static final ConcurrentMap<String, String> QUERY_CACHE = new ConcurrentHashMap<String, String>(50);
    private String scriptsFolder;

    public FileQueryLoader(String scriptsFolder) {
        this.scriptsFolder = scriptsFolder;
    }

    @Override
    public String load(String queryName) {
        if (!QUERY_CACHE.containsKey(queryName)) {
            QUERY_CACHE.put(queryName, this.loadfromFromFile(queryName));
        }
        return (String)QUERY_CACHE.get(queryName);
    }

    @Override
    public String[] loadMultiple(String queryName, char separator) {
        String fullSql = this.load(queryName);
        return StringUtils.split((String)fullSql, (char)separator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadfromFromFile(String queryName) throws IllegalStateException {
        try (InputStream is = this.getClass().getResourceAsStream(this.scriptsFolder + queryName + ".sql");){
            String string = StringUtils.join((Iterable)IOUtils.readLines((InputStream)is), (char)' ');
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load query " + this.scriptsFolder + queryName, e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.scriptsFolder, (String)"scriptsFolder cannot be null");
    }
}

