/*
 * Decompiled with CFR 0.152.
 */
package com.stuart.stuartclientjava.infrastructure;

import com.stuart.stuartclientjava.infrastructure.ApiResponse;
import com.stuart.stuartclientjava.infrastructure.Authenticator;
import com.stuart.stuartclientjava.infrastructure.Version;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient {
    protected OkHttpClient client;
    private Authenticator authenticator;

    public HttpClient(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.client = new OkHttpClient();
    }

    public ApiResponse performGet(String resource) throws IOException {
        Request request = new Request.Builder().url(this.getFullUrl(resource)).headers(Headers.of(this.getDefaultHeaders())).build();
        Response response = this.client.newCall(request).execute();
        return new ApiResponse(response.code(), response.body().string());
    }

    public ApiResponse performPost(String resource, String body) throws IOException {
        Request request = new Request.Builder().url(this.getFullUrl(resource)).headers(Headers.of(this.getDefaultHeaders())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)body)).build();
        Response response = this.client.newCall(request).execute();
        return new ApiResponse(response.code(), response.body().string());
    }

    public ApiResponse performPatch(String resource, String body) throws IOException {
        Request request = new Request.Builder().url(this.getFullUrl(resource)).headers(Headers.of(this.getDefaultHeaders())).patch(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)body)).build();
        Response response = this.client.newCall(request).execute();
        return new ApiResponse(response.code(), response.body().string());
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Authorization", String.format("Bearer %s", this.authenticator.getAccessToken()));
        result.put("User-Agent", String.format("stuart-client-java/%s", new Version().getCurrent()));
        result.put("Content-Type", "application/json");
        return result;
    }

    private String getFullUrl(String resource) {
        return String.format("%s%s", this.authenticator.getEnvironment().baseUrl(), resource);
    }
}

