/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestAnnotationTest {
    @Test
    public void testFindAnnotationDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build()));
    }

    @Test
    public void testFindAnnotationDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findAnnotationDifferences(null, null));
    }

    @Test
    public void testFindAnnotationDifferencesDoc1NullDoc2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the annotations is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences(null, (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build()));
    }

    @Test
    public void testFindAnnotationDifferencesDoc2NullDoc1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the annotations is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build(), null));
    }

    @Test
    public void testFindAnnotationDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)UneditableJavaAnnotation.builder().name("Test").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build()));
    }

    @Test
    public void testFindAnnotationDifferencesName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Name is different!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Derp").build()));
    }

    @Test
    public void testFindAnnotationDifferencesCanonicalName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Canonical Name is different!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").canonicalName("com.test.Test").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").canonicalName("com.derp.Test").build()));
    }

    @Test
    public void testFindAnnotationDifferencesParamsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Parameters length is different!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").parameter("version", "It a version").build()));
    }

    @Test
    public void testFindAnnotationDifferencesParamsLengthDoc1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Parameters length is different!", "Parameters differs on #2!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").parameter("version", "It a version").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").build()));
    }

    @Test
    public void testFindAnnotationDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Name is different!", "Canonical Name is different!", "Parameters length is different!", "Parameters differs on #2!"}), (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)UneditableJavaAnnotation.builder().name("Test").canonicalName("com.test.Test").parameter("something", "We doing something with it").parameter("version", "It a version").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Derp").canonicalName("com.derp.Test").parameter("something", "We doing something with it").build()));
    }

    @Test
    public void testAssertAnnotationEqualsNone() {
        JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build(), (JavaAnnotation)EditableJavaAnnotation.builder().name("Test").build());
    }

    @Test
    public void testAssertAnnotationEqualsBothNull() {
        JavaCodeTypeTest.assertAnnotationEquals(null, null);
    }

    @Test
    public void testAssertAnnotationEqualsDoc1NullDoc2Not() {
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Test").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals(null, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the annotations is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)annotation2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsDoc2NullDoc1Not() {
        JavaAnnotation annotation1 = EditableJavaAnnotation.builder().name("Test").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the annotations is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsEditable() {
        JavaAnnotation annotation1 = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Test").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, (Object)annotation2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsName() {
        JavaAnnotation annotation1 = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Derp").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, (Object)annotation2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsCanonicalName() {
        JavaAnnotation annotation1 = EditableJavaAnnotation.builder().name("Test").canonicalName("com.test.Test").build();
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Test").canonicalName("com.derp.Test").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Canonical Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, (Object)annotation2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsParamsLength() {
        JavaAnnotation annotation1 = EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").build();
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").parameter("version", "It a version").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Parameters length is different!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, (Object)annotation2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsParamsLengthDoc1Longer() {
        JavaAnnotation annotation1 = EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").parameter("version", "It a version").build();
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Parameters length is different!\nParameters differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, (Object)annotation2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertAnnotationEqualsAll() {
        JavaAnnotation annotation1 = UneditableJavaAnnotation.builder().name("Test").canonicalName("com.test.Test").parameter("something", "We doing something with it").parameter("version", "It a version").build();
        JavaAnnotation annotation2 = EditableJavaAnnotation.builder().name("Derp").canonicalName("com.derp.Test").parameter("something", "We doing something with it").build();
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)annotation1, (JavaAnnotation)annotation2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nName is different!\nCanonical Name is different!\nParameters length is different!\nParameters differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)annotation1, (Object)annotation2)), (Object)e.getMessage());
        }
    }
}

