/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestFieldTest {
    @Test
    public void testFindFieldDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().type("String").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findFieldDifferences(null, null));
    }

    @Test
    public void testFindFieldDifferencesField1NullField2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the fields is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findFieldDifferences(null, (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesField2NullField1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the fields is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().type("String").name("Test").build(), null));
    }

    @Test
    public void testFindFieldDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)UneditableJavaField.builder().type("String").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesJavadoc() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().javadoc(EditableJavadoc.builder().build()).type("String").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesAnnotationsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations length is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build(), (JavaField)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesAnnotationsLength1() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations length is different!", "Annotations differs on #2!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build(), (JavaField)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesAnnotationsContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations differs on #1:\n\tName is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build(), (JavaField)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesVisibility() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Visibility is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("Test").build(), (JavaField)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesStatic() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Static is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().isStatic().type("String").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesFinal() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Final is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().isFinal().type("String").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesType() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Type is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().type("int").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Name is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().type("String").name("version").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesValue() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Value is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().type("String").name("Test").value("\"Something\"").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build()));
    }

    @Test
    public void testFindFieldDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", "Annotations length is different!", "Annotations differs on #1:\n\tEditable is different!\n\tName is different!", "Annotations differs on #2!", "Visibility is different!", "Static is different!", "Final is different!", "Type is different!", "Name is different!", "Value is different!"}), (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)EditableJavaField.builder().javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("int").name("version").value("25").build(), (JavaField)UneditableJavaField.builder().annotation(UneditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).type("String").name("Test").build()));
    }

    @Test
    public void testAssertFieldEqualsNone() {
        JavaCodeTypeTest.assertFieldEquals((JavaField)EditableJavaField.builder().type("String").name("Test").build(), (JavaField)EditableJavaField.builder().type("String").name("Test").build());
    }

    @Test
    public void testAssertFieldEqualsBothNull() {
        JavaCodeTypeTest.assertFieldEquals(null, null);
    }

    @Test
    public void testAssertFieldEqualsField1NullField2Not() {
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals(null, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the fields is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsField2NullField1Not() {
        JavaField field1 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the fields is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)field1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsEditable() {
        JavaField field1 = UneditableJavaField.builder().type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsJavadoc() {
        JavaField field1 = EditableJavaField.builder().javadoc(EditableJavadoc.builder().build()).type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsAnnotationsLength() {
        JavaField field1 = EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations length is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsAnnotationsLength1() {
        JavaField field1 = EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations length is different!\nAnnotations differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsAnnotationsContent() {
        JavaField field1 = EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations differs on #1:\n\tName is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsVisibility() {
        JavaField field1 = EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Visibility is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsStatic() {
        JavaField field1 = EditableJavaField.builder().isStatic().type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Static is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsFinal() {
        JavaField field1 = EditableJavaField.builder().isFinal().type("String").name("Test").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Final is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsType() {
        JavaField field1 = EditableJavaField.builder().type("int").name("Test").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Type is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsName() {
        JavaField field1 = EditableJavaField.builder().type("String").name("version").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsValue() {
        JavaField field1 = EditableJavaField.builder().type("String").name("Test").value("\"Something\"").build();
        JavaField field2 = EditableJavaField.builder().type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Value is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertFieldEqualsAll() {
        JavaField field1 = EditableJavaField.builder().javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("int").name("version").value("25").build();
        JavaField field2 = UneditableJavaField.builder().annotation(UneditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).type("String").name("Test").build();
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)field1, (JavaField)field2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nJavadoc differs:\n\tOne of the Javadocs is null, and the other isn't!\nAnnotations length is different!\nAnnotations differs on #1:\n\tEditable is different!\n\tName is different!\nAnnotations differs on #2!\nVisibility is different!\nStatic is different!\nFinal is different!\nType is different!\nName is different!\nValue is different!", (String)AssertionFailedErrors.buildAssertError((Object)field1, (Object)field2)), (Object)e.getMessage());
        }
    }
}

