/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class ByteUtilTest
extends JavaClassParsingTest {
    public ByteUtilTest() {
        super("package com.github.tadukoo.util;\n\n/**\n * Util functions for dealing with bytes.\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n */\npublic final class ByteUtil{\n\t\n\t/** An array containing 0-9 and then A-F, used for converting to hex */\n\tpublic static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\t\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'};\n\t\n\t/** Not allowed to create a ByteUtil */\n\tprivate ByteUtil(){ }\n\t\n\t/**\n\t * Gets the bit at the given position\n\t * \n\t * @param bite The byte to grab a bit from\n\t * @param position The position of the bit to be grabbed\n\t * @return The value of the bit at the given position\n\t */\n\tpublic static int getBit(byte bite, int position){\n\t\treturn (bite >>> position) & 1;\n\t}\n\t\n\t/**\n\t * Sets the bit at the given position (to 1/true)\n\t * \n\t * @param bite The byte to set the bit on\n\t * @param position The position of the bit to be set\n\t * @return A byte with the given bit set\n\t */\n\tpublic static byte setBit(byte bite, int position){\n\t\treturn (byte) (bite | (1 << position));\n\t}\n\t\n\t/**\n\t * Clears the bit at the given position (sets to 0/false)\n\t * \n\t * @param bite The byte to clear the bit on\n\t * @param position The position of the bit to be cleared\n\t * @return A byte with the given bit cleared\n\t */\n\tpublic static byte clearBit(byte bite, int position){\n\t\treturn (byte) (bite & ~(1 << position));\n\t}\n\t\n\t/**\n\t * Toggles the bit at the given position\n\t * \n\t * @param bite The byte to toggle the bit on\n\t * @param position The position of the bit to be toggled\n\t * @return A byte with the given bit toggled\n\t */\n\tpublic static byte toggleBit(byte bite, int position){\n\t\treturn (byte) (bite ^ (1 << position));\n\t}\n\t\n\t/**\n\t * Checks if the bit at the given position is set or not\n\t * \n\t * @param bite The byte to check a bit from\n\t * @param position The position of the bit to be checked\n\t * @return true if the bit is set (equal to 1) or false if not set (equal to 0)\n\t */\n\tpublic static boolean checkBit(byte bite, int position){\n\t\treturn getBit(bite, position) == 1;\n\t}\n\t\n\t/**\n\t * Parse the given byte into a binary string\n\t * \n\t * @param bite The byte to be converted to a binary string\n\t * @return The binary string representation of the byte\n\t */\n\tpublic static String toBinaryString(byte bite){\n\t\treturn String.format(\"%8s\", Integer.toBinaryString(bite & 0xFF)).replace(' ', '0');\n\t}\n\t\n\t/**\n\t * Parse the given String into a byte. String should be a binary representation of a byte\n\t * \n\t * @param byteString The binary representation of a byte\n\t * @return A Byte parsed from the given binary String\n\t */\n\tpublic static Byte parseByte(String byteString){\n\t\treturn (byte) Integer.parseInt(byteString, 2);\n\t}\n\t\n\t/**\n\t * Returns the byte as an int, signed (-128 to 127)\n\t * \n\t * @param bite The byte to convert to an int\n\t * @return The int value of the given byte\n\t */\n\tpublic static int toSignedInt(byte bite){\n\t\treturn bite;\n\t}\n\t\n\t/**\n\t * Returns the byte as an unsigned int (0 to 255)\n\t * \n\t * @param bite The byte to convert to an int\n\t * @return The int value of the given byte\n\t */\n\tpublic static int toUnsignedInt(byte bite){\n\t\treturn Byte.toUnsignedInt(bite);\n\t}\n\t\n\t/**\n\t * Converts the given byte to a 2 digit hex string\n\t * \n\t * @param bite The byte to convert to hex\n\t * @return The hex representation of the given byte\n\t */\n\tpublic static String toHex(byte bite){\n\t\treturn String.valueOf(hexChars[(bite >>> 4) & 0xF]) + hexChars[bite & 0xF];\n\t}\n\t\n\t/**\n\t * Converts the given byte array into a hex string\n\t * \n\t * @param bytes The bytes to convert to hex\n\t * @return The hex representation of the given bytes\n\t */\n\tpublic static String toHex(byte[] bytes){\n\t\tStringBuilder hex = new StringBuilder();\n\t\tfor(byte bite: bytes){\n\t\t\thex.append(toHex(bite));\n\t\t}\n\t\treturn hex.toString();\n\t}\n\t\n\t/**\n\t * Converts the given hex character to an int\n\t * \n\t * @param hexChar The hex character to convert\n\t * @return The int value of the hex character, or -1 if invalid\n\t */\n\tpublic static int hexToInt(char hexChar){\n\t\tif('0' <= hexChar && hexChar <= '9'){\n\t\t\treturn hexChar - '0';\n\t\t}else if('A' <= hexChar && hexChar <= 'F'){\n\t\t\treturn hexChar - 'A' + 10;\n\t\t}else if('a' <= hexChar && hexChar <= 'f'){\n\t\t\treturn hexChar - 'a' + 10;\n\t\t}else{\n\t\t\treturn -1;\n\t\t}\n\t}\n\t\n\t/**\n\t * Convert the given hex string into a byte array\n\t * \n\t * @param hex The hex string to convert\n\t * @return A byte array representing the given hex string\n\t */\n\tpublic static byte[] fromHex(String hex){\n\t\tint size = hex.length();\n\t\t\n\t\t// Check that the size is even\n\t\tif(size % 2 != 0){\n\t\t\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);\n\t\t}\n\t\t\n\t\t// Create byte array to store the bytes in\n\t\tbyte[] bites = new byte[size/2];\n\t\t\n\t\t// Iterate over the string, 2 characters at a time\n\t\tfor(int i = 0; i < size; i+=2){\n\t\t\tint highNibble = hexToInt(hex.charAt(i));\n\t\t\tint lowNibble = hexToInt(hex.charAt(i+1));\n\t\t\t// If either nibble came out -1, we have an illegal hex character\n\t\t\tif(highNibble == -1 || lowNibble == -1){\n\t\t\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);\n\t\t\t}\n\t\t\t\n\t\t\tbites[i/2] = (byte) (highNibble*16 + lowNibble);\n\t\t}\n\t\t\n\t\treturn bites;\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util").javadoc(EditableJavadoc.builder().content("Util functions for dealing with bytes.").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").build()).visibility(Visibility.PUBLIC).isFinal().className("ByteUtil").field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("An array containing 0-9 and then A-F, used for converting to hex").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("char[]").name("hexChars").value("new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'}").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("Not allowed to create a ByteUtil").build()).visibility(Visibility.PRIVATE).returnType("ByteUtil").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Gets the bit at the given position").param("bite", "The byte to grab a bit from").param("position", "The position of the bit to be grabbed").returnVal("The value of the bit at the given position").build()).visibility(Visibility.PUBLIC).isStatic().returnType("int").name("getBit").parameter("byte", "bite").parameter("int", "position").line("return (bite >>> position) & 1;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Sets the bit at the given position (to 1/true)").param("bite", "The byte to set the bit on").param("position", "The position of the bit to be set").returnVal("A byte with the given bit set").build()).visibility(Visibility.PUBLIC).isStatic().returnType("byte").name("setBit").parameter("byte", "bite").parameter("int", "position").line("return (byte) (bite | (1 << position));").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Clears the bit at the given position (sets to 0/false)").param("bite", "The byte to clear the bit on").param("position", "The position of the bit to be cleared").returnVal("A byte with the given bit cleared").build()).visibility(Visibility.PUBLIC).isStatic().returnType("byte").name("clearBit").parameter("byte", "bite").parameter("int", "position").line("return (byte) (bite & ~(1 << position));").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Toggles the bit at the given position").param("bite", "The byte to toggle the bit on").param("position", "The position of the bit to be toggled").returnVal("A byte with the given bit toggled").build()).visibility(Visibility.PUBLIC).isStatic().returnType("byte").name("toggleBit").parameter("byte", "bite").parameter("int", "position").line("return (byte) (bite ^ (1 << position));").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Checks if the bit at the given position is set or not").param("bite", "The byte to check a bit from").param("position", "The position of the bit to be checked").returnVal("true if the bit is set (equal to 1) or false if not set (equal to 0)").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("checkBit").parameter("byte", "bite").parameter("int", "position").line("return getBit(bite, position) == 1;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Parse the given byte into a binary string").param("bite", "The byte to be converted to a binary string").returnVal("The binary string representation of the byte").build()).visibility(Visibility.PUBLIC).isStatic().returnType("String").name("toBinaryString").parameter("byte", "bite").line("return String.format(\"%8s\", Integer.toBinaryString(bite & 0xFF)).replace(' ', '0');").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Parse the given String into a byte. String should be a binary representation of a byte").param("byteString", "The binary representation of a byte").returnVal("A Byte parsed from the given binary String").build()).visibility(Visibility.PUBLIC).isStatic().returnType("Byte").name("parseByte").parameter("String", "byteString").line("return (byte) Integer.parseInt(byteString, 2);").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Returns the byte as an int, signed (-128 to 127)").param("bite", "The byte to convert to an int").returnVal("The int value of the given byte").build()).visibility(Visibility.PUBLIC).isStatic().returnType("int").name("toSignedInt").parameter("byte", "bite").line("return bite;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Returns the byte as an unsigned int (0 to 255)").param("bite", "The byte to convert to an int").returnVal("The int value of the given byte").build()).visibility(Visibility.PUBLIC).isStatic().returnType("int").name("toUnsignedInt").parameter("byte", "bite").line("return Byte.toUnsignedInt(bite);").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Converts the given byte to a 2 digit hex string").param("bite", "The byte to convert to hex").returnVal("The hex representation of the given byte").build()).visibility(Visibility.PUBLIC).isStatic().returnType("String").name("toHex").parameter("byte", "bite").line("return String.valueOf(hexChars[(bite >>> 4) & 0xF]) + hexChars[bite & 0xF];").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Converts the given byte array into a hex string").param("bytes", "The bytes to convert to hex").returnVal("The hex representation of the given bytes").build()).visibility(Visibility.PUBLIC).isStatic().returnType("String").name("toHex").parameter("byte[]", "bytes").line("StringBuilder hex = new StringBuilder();").line("for(byte bite: bytes){").line("\thex.append(toHex(bite));").line("}").line("return hex.toString();").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Converts the given hex character to an int").param("hexChar", "The hex character to convert").returnVal("The int value of the hex character, or -1 if invalid").build()).visibility(Visibility.PUBLIC).isStatic().returnType("int").name("hexToInt").parameter("char", "hexChar").line("if('0' <= hexChar && hexChar <= '9'){").line("\treturn hexChar - '0';").line("}else if('A' <= hexChar && hexChar <= 'F'){").line("\treturn hexChar - 'A' + 10;").line("}else if('a' <= hexChar && hexChar <= 'f'){").line("\treturn hexChar - 'a' + 10;").line("}else{").line("\treturn -1;").line("}").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Convert the given hex string into a byte array").param("hex", "The hex string to convert").returnVal("A byte array representing the given hex string").build()).visibility(Visibility.PUBLIC).isStatic().returnType("byte[]").name("fromHex").parameter("String", "hex").line("int size = hex.length();").line("").line("// Check that the size is even").line("if(size % 2 != 0){").line("\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);").line("}").line("").line("// Create byte array to store the bytes in").line("byte[] bites = new byte[size/2];").line("").line("// Iterate over the string, 2 characters at a time").line("for(int i = 0; i < size; i+=2){").line("\tint highNibble = hexToInt(hex.charAt(i));").line("\tint lowNibble = hexToInt(hex.charAt(i+1));").line("\t// If either nibble came out -1, we have an illegal hex character").line("\tif(highNibble == -1 || lowNibble == -1){").line("\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);").line("\t}").line("\t").line("\tbites[i/2] = (byte) (highNibble*16 + lowNibble);").line("}").line("").line("return bites;").build()).build());
    }
}

