/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class CharacterUtilTest
extends JavaClassParsingTest {
    public CharacterUtilTest() {
        super("package com.github.tadukoo.util;\n\n/**\n * Util functions for dealing with Characters.\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.3.1\n */\npublic final class CharacterUtil{\n\t\n\t/** Not allowed to create a CharacterUtil */\n\tprivate CharacterUtil(){ }\n\t\n\t/**\n\t * @param c The character to be checked\n\t * @return true if the given character is a capital letter, false otherwise\n\t */\n\tpublic static boolean isUpperCase(char c){\n\t\treturn c >= 'A' && c <= 'Z';\n\t}\n\t\n\t/**\n\t * @param c The character to be checked\n\t * @return true if the given character is a lowercase letter, false otherwise\n\t */\n\tpublic static boolean isLowerCase(char c){\n\t\treturn c >= 'a' && c <= 'z';\n\t}\n\t\n\t/**\n\t * @param c The character to be checked\n\t * @return true if the given character is a letter, false otherwise\n\t */\n\tpublic static boolean isLetter(char c){\n\t\treturn isUpperCase(c) || isLowerCase(c);\n\t}\n\t\n\t/**\n\t * @param c The character to be checked\n\t * @return true if the given character is a number, false otherwise\n\t */\n\tpublic static boolean isNumber(char c){\n\t\treturn c >= '0' && c <= '9';\n\t}\n\t\n\t/**\n\t * @param c The character to be capitalized\n\t * @return The capital version of the given character, or the character itself if it's not a letter\n\t */\n\tpublic static char toUpperCase(char c){\n\t\tif(isLowerCase(c)){\n\t\t\treturn (char) (c - 32);\n\t\t}else{\n\t\t\treturn c;\n\t\t}\n\t}\n\t\n\t/**\n\t * @param c The character to change to lowercase\n\t * @return The lowercase version of the given character, or the character itself if it's not a letter\n\t */\n\tpublic static char toLowerCase(char c){\n\t\tif(isUpperCase(c)){\n\t\t\treturn (char) (c + 32);\n\t\t}else{\n\t\t\treturn c;\n\t\t}\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util").javadoc(EditableJavadoc.builder().content("Util functions for dealing with Characters.").author("Logan Ferree (Tadukoo)").version("Alpha v.0.3.1").build()).visibility(Visibility.PUBLIC).isFinal().className("CharacterUtil").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("Not allowed to create a CharacterUtil").build()).visibility(Visibility.PRIVATE).returnType("CharacterUtil").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().param("c", "The character to be checked").returnVal("true if the given character is a capital letter, false otherwise").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isUpperCase").parameter("char", "c").line("return c >= 'A' && c <= 'Z';").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().param("c", "The character to be checked").returnVal("true if the given character is a lowercase letter, false otherwise").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isLowerCase").parameter("char", "c").line("return c >= 'a' && c <= 'z';").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().param("c", "The character to be checked").returnVal("true if the given character is a letter, false otherwise").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isLetter").parameter("char", "c").line("return isUpperCase(c) || isLowerCase(c);").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().param("c", "The character to be checked").returnVal("true if the given character is a number, false otherwise").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isNumber").parameter("char", "c").line("return c >= '0' && c <= '9';").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().param("c", "The character to be capitalized").returnVal("The capital version of the given character, or the character itself if it's not a letter").build()).visibility(Visibility.PUBLIC).isStatic().returnType("char").name("toUpperCase").parameter("char", "c").line("if(isLowerCase(c)){").line("\treturn (char) (c - 32);").line("}else{").line("\treturn c;").line("}").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().param("c", "The character to change to lowercase").returnVal("The lowercase version of the given character, or the character itself if it's not a letter").build()).visibility(Visibility.PUBLIC).isStatic().returnType("char").name("toLowerCase").parameter("char", "c").line("if(isUpperCase(c)){").line("\treturn (char) (c + 32);").line("}else{").line("\treturn c;").line("}").build()).build());
    }
}

