/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util.download;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class DownloadUtilTest
extends JavaClassParsingTest {
    public DownloadUtilTest() {
        super("package com.github.tadukoo.util.download;\n\nimport com.github.tadukoo.util.logger.EasyLogger;\n\nimport java.io.File;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\nimport java.net.HttpURLConnection;\nimport java.net.URL;\nimport java.nio.channels.Channels;\nimport java.nio.channels.FileChannel;\nimport java.nio.channels.ReadableByteChannel;\n\n/**\n * Download Util contains utilities used for downloading files\n * \n * @author Logan Ferree\n * @version Beta v.0.5.2\n */\npublic class DownloadUtil{\n\t\n\t/** Not allowed to instantiate DownloadUtil */\n\tprivate DownloadUtil(){ }\n\t\n\t/**\n\t * Attempts to grab the file size for the file at the given {@link URL}. If it fails, a warning\n\t * will be logged, but it will not error out and return -1\n\t * \n\t * @param logger The {@link EasyLogger logger} to use for logging if we fail\n\t * @param url The {@link URL} the file is located at\n\t * @return The size of the file in bytes, or -1 if we fail to retrieve it\n\t */\n\tpublic static int getFileSize(EasyLogger logger, URL url){\n\t\t// Set file size default to -1 (so we can at least return something if it fails)\n\t\tint fileLength = -1;\n\t\t\n\t\ttry{\n\t\t\t// Follow redirects for grabbing file size (set in case something else set it to false)\n\t\t\tHttpURLConnection.setFollowRedirects(true);\n\t\t\t\n\t\t\t// Setup a connection to get the HEAD for the file\n\t\t\tHttpURLConnection connection = (HttpURLConnection) url.openConnection();\n\t\t\tconnection.setRequestMethod(\"HEAD\");\n\t\t\t\n\t\t\t// Grab the file size from the connection\n\t\t\tfileLength = connection.getContentLength();\n\t\t}catch(Exception e){\n\t\t\t// Log warning that we couldn't get file size + notify user\n\t\t\tlogger.logWarning(\"Failed to get file size at url: \" + url.getPath(), e);\n\t\t}\n\t\t\n\t\treturn fileLength;\n\t}\n\t\n\t/**\n\t * If the file already exists at the given filepath, nothing happens. Otherwise, we download it from the\n\t * given address, and progress will be updated by sending this as a {@link ProgressRBCWrapperListener} to\n\t * the {@link ProgressReadableByteChannelWrapper} we use\n\t * \n\t * @param logger The {@link EasyLogger logger} to use for logging\n\t * @param listener The {@link ProgressRBCWrapperListener progress listener} to send updates to\n\t * @param address The URL for the file to be downloaded\n\t * @param filepath The local filepath for the file\n\t * @throws IOException If anything goes wrong in downloading the file\n\t */\n\tpublic static void downloadFile(\n\t\t\tEasyLogger logger, ProgressRBCWrapperListener listener, String address, String filepath) throws IOException{\n\t\t// Check if file already exists so we don't need to download it\n\t\tFile file = new File(filepath);\n\t\tif(file.exists()){\n\t\t\treturn;\n\t\t}\n\t\t\n\t\t// Setup the download, including setting this as the listener for progress updates\n\t\tURL url = new URL(address);\n\t\t// Follow redirects for the file (set in case something else sets it to false)\n\t\tHttpURLConnection.setFollowRedirects(true);\n\t\tReadableByteChannel fileDownload = new ProgressReadableByteChannelWrapper(\n\t\tChannels.newChannel(url.openStream()), listener, getFileSize(logger, url));\n\t\t\n\t\t// Perform the file transfer from the URL to our local filepath\n\t\tFileOutputStream fileOutputStream = new FileOutputStream(filepath);\n\t\tFileChannel fileChannel = fileOutputStream.getChannel();\n\t\tfileChannel.transferFrom(fileDownload, 0, Long.MAX_VALUE);\n\t\t\n\t\t// Close the file channels and output stream now that we're done\n\t\tfileDownload.close();\n\t\tfileChannel.close();\n\t\tfileOutputStream.close();\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util.download").importName("com.github.tadukoo.util.logger.EasyLogger", false).importName("java.io.File", false).importName("java.io.FileOutputStream", false).importName("java.io.IOException", false).importName("java.net.HttpURLConnection", false).importName("java.net.URL", false).importName("java.nio.channels.Channels", false).importName("java.nio.channels.FileChannel", false).importName("java.nio.channels.ReadableByteChannel", false).javadoc(EditableJavadoc.builder().content("Download Util contains utilities used for downloading files").author("Logan Ferree").version("Beta v.0.5.2").build()).visibility(Visibility.PUBLIC).className("DownloadUtil").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("Not allowed to instantiate DownloadUtil").build()).visibility(Visibility.PRIVATE).returnType("DownloadUtil").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Attempts to grab the file size for the file at the given {@link URL}. If it fails, a warning").content("will be logged, but it will not error out and return -1").param("logger", "The {@link EasyLogger logger} to use for logging if we fail").param("url", "The {@link URL} the file is located at").returnVal("The size of the file in bytes, or -1 if we fail to retrieve it").build()).visibility(Visibility.PUBLIC).isStatic().returnType("int").name("getFileSize").parameter("EasyLogger", "logger").parameter("URL", "url").line("// Set file size default to -1 (so we can at least return something if it fails)").line("int fileLength = -1;").line("").line("try{").line("\t// Follow redirects for grabbing file size (set in case something else set it to false)").line("\tHttpURLConnection.setFollowRedirects(true);").line("\t").line("\t// Setup a connection to get the HEAD for the file").line("\tHttpURLConnection connection = (HttpURLConnection) url.openConnection();").line("\tconnection.setRequestMethod(\"HEAD\");").line("\t").line("\t// Grab the file size from the connection").line("\tfileLength = connection.getContentLength();").line("}catch(Exception e){").line("\t// Log warning that we couldn't get file size + notify user").line("\tlogger.logWarning(\"Failed to get file size at url: \" + url.getPath(), e);").line("}").line("").line("return fileLength;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("If the file already exists at the given filepath, nothing happens. Otherwise, we download it from the").content("given address, and progress will be updated by sending this as a {@link ProgressRBCWrapperListener} to").content("the {@link ProgressReadableByteChannelWrapper} we use").param("logger", "The {@link EasyLogger logger} to use for logging").param("listener", "The {@link ProgressRBCWrapperListener progress listener} to send updates to").param("address", "The URL for the file to be downloaded").param("filepath", "The local filepath for the file").throwsInfo("IOException", "If anything goes wrong in downloading the file").build()).visibility(Visibility.PUBLIC).isStatic().returnType("void").name("downloadFile").parameter("EasyLogger", "logger").parameter("ProgressRBCWrapperListener", "listener").parameter("String", "address").parameter("String", "filepath").throwType("IOException").line("// Check if file already exists so we don't need to download it").line("File file = new File(filepath);").line("if(file.exists()){").line("\treturn;").line("}").line("").line("// Setup the download, including setting this as the listener for progress updates").line("URL url = new URL(address);").line("// Follow redirects for the file (set in case something else sets it to false)").line("HttpURLConnection.setFollowRedirects(true);").line("ReadableByteChannel fileDownload = new ProgressReadableByteChannelWrapper(").line("Channels.newChannel(url.openStream()), listener, getFileSize(logger, url));").line("").line("// Perform the file transfer from the URL to our local filepath").line("FileOutputStream fileOutputStream = new FileOutputStream(filepath);").line("FileChannel fileChannel = fileOutputStream.getChannel();").line("fileChannel.transferFrom(fileDownload, 0, Long.MAX_VALUE);").line("").line("// Close the file channels and output stream now that we're done").line("fileDownload.close();").line("fileChannel.close();").line("fileOutputStream.close();").build()).build());
    }
}

