/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestAnnotationTest {
    @ParameterizedTest
    @MethodSource(value={"getAnnotationDifferences"})
    public void testFindAnnotationDifferences(JavaAnnotation expectedAnnotation, JavaAnnotation actualAnnotation, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findAnnotationDifferences((JavaAnnotation)expectedAnnotation, (JavaAnnotation)actualAnnotation));
    }

    @ParameterizedTest
    @MethodSource(value={"getAnnotationDifferences"})
    public void testAssertAnnotationEquals(JavaAnnotation expectedAnnotation, JavaAnnotation actualAnnotation, List<String> differences) {
        try {
            JavaCodeTypeTest.assertAnnotationEquals((JavaAnnotation)expectedAnnotation, (JavaAnnotation)actualAnnotation);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedAnnotation, (Object)actualAnnotation)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getAnnotationDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").build(), EditableJavaAnnotation.builder().name("Test").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaAnnotation.builder().name("Test").build(), ListUtil.createList((Object[])new String[]{"One of the annotations is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").build(), null, ListUtil.createList((Object[])new String[]{"One of the annotations is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaAnnotation.builder().name("Test").build(), EditableJavaAnnotation.builder().name("Test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").build(), EditableJavaAnnotation.builder().name("Derp").build(), ListUtil.createList((Object[])new String[]{"Name is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").canonicalName("com.test.Test").build(), EditableJavaAnnotation.builder().name("Test").canonicalName("com.derp.Test").build(), ListUtil.createList((Object[])new String[]{"Canonical Name is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").build(), EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").parameter("version", "It a version").build(), ListUtil.createList((Object[])new String[]{"Parameters length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").parameter("version", "It a version").build(), EditableJavaAnnotation.builder().name("Test").parameter("something", "We doing something with it").build(), ListUtil.createList((Object[])new String[]{"Parameters length is different!", "Parameters differs on #2!"})}), Arguments.of((Object[])new Object[]{UneditableJavaAnnotation.builder().name("Test").canonicalName("com.test.Test").parameter("something", "We doing something with it").parameter("version", "It a version").build(), EditableJavaAnnotation.builder().name("Derp").canonicalName("com.derp.Test").parameter("something", "We doing something with it").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Name is different!", "Canonical Name is different!", "Parameters length is different!", "Parameters differs on #2!"})}));
    }
}

