/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestFieldTest {
    @ParameterizedTest
    @MethodSource(value={"getFieldDifferences"})
    public void testFindFieldDifferences(JavaField expectedField, JavaField actualField, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findFieldDifferences((JavaField)expectedField, (JavaField)actualField));
    }

    @ParameterizedTest
    @MethodSource(value={"getFieldDifferences"})
    public void testAssertFieldEquals(JavaField expectedField, JavaField actualField, List<String> differences) {
        try {
            JavaCodeTypeTest.assertFieldEquals((JavaField)expectedField, (JavaField)actualField);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedField, (Object)actualField)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getFieldDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaField.builder().type("String").name("Test").build(), EditableJavaField.builder().type("String").name("Test").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"One of the fields is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().type("String").name("Test").build(), null, ListUtil.createList((Object[])new String[]{"One of the fields is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaField.builder().type("String").name("Test").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().javadoc(EditableJavadoc.builder().build()).type("String").name("Test").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build(), EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Annotations length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build(), EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Annotations length is different!", "Annotations differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("Test").build(), EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Derp").build()).type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Annotations differs on #1:\n\tName is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("Test").build(), EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Visibility is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().isStatic().type("String").name("Test").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Static is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().isFinal().type("String").name("Test").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Final is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().type("int").name("Test").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Type differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().type("String").name("version").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Name is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().type("String").name("Test").value("\"Something\"").build(), EditableJavaField.builder().type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Value is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("int").name("version").value("25").build(), UneditableJavaField.builder().annotation(UneditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).type("String").name("Test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", "Annotations length is different!", "Annotations differs on #1:\n\tEditable is different!\n\tName is different!", "Annotations differs on #2!", "Visibility is different!", "Static is different!", "Final is different!", "Type differs:\n\tBase Type is different!", "Name is different!", "Value is different!"})}));
    }
}

