/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestParameterTest {
    @ParameterizedTest
    @MethodSource(value={"getParameterDifferences"})
    public void testFindParameterDifferences(JavaParameter expectedParameter, JavaParameter actualParameter, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findParameterDifferences((JavaParameter)expectedParameter, (JavaParameter)actualParameter));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameterDifferences"})
    public void testAssertParameterEquals(JavaParameter expectedParameter, JavaParameter actualParameter, List<String> differences) {
        try {
            JavaCodeTypeTest.assertParameterEquals((JavaParameter)expectedParameter, (JavaParameter)actualParameter);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedParameter, (Object)actualParameter)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getParameterDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), ListUtil.createList((Object[])new String[]{"One of the parameters is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), null, ListUtil.createList((Object[])new String[]{"One of the parameters is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("text").build(), ListUtil.createList((Object[])new String[]{"Type differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").vararg().build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), ListUtil.createList((Object[])new String[]{"Vararg is different!"})}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text1").build(), ListUtil.createList((Object[])new String[]{"Name is different!"})}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").vararg().build(), JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("text1").build(), ListUtil.createList((Object[])new String[]{"Type differs:\n\tBase Type is different!", "Vararg is different!", "Name is different!"})}));
    }
}

