/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestTypeParameterTest {
    @ParameterizedTest
    @MethodSource(value={"getTypeParameterDifferences"})
    public void testFindTypeParameterDifferences(JavaTypeParameter expectedTypeParameter, JavaTypeParameter actualTypeParameter, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findTypeParameterDifferences((JavaTypeParameter)expectedTypeParameter, (JavaTypeParameter)actualTypeParameter));
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeParameterDifferences"})
    public void testAssertTypeParameterEquals(JavaTypeParameter expectedTypeParameter, JavaTypeParameter actualTypeParameter, List<String> differences) {
        try {
            JavaCodeTypeTest.assertTypeParameterEquals((JavaTypeParameter)expectedTypeParameter, (JavaTypeParameter)actualTypeParameter);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedTypeParameter, (Object)actualTypeParameter)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getTypeParameterDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), ListUtil.createList((Object[])new String[]{"One of the type parameters is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), null, ListUtil.createList((Object[])new String[]{"One of the type parameters is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("int").build()).build(), ListUtil.createList((Object[])new String[]{"Base Type differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("Object").build()).build(), ListUtil.createList((Object[])new String[]{"Extends Type differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), ListUtil.createList((Object[])new String[]{"Base Type differs:\n\tBase Type is different!", "Extends Type differs:\n\tOne of the types is null, and the other isn't!"})}));
    }
}

