/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaClassBuilder;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavaField;
import com.github.tadukoo.java.uneditable.UneditableJavaMethod;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaClassBuilderTest {
    private String packageName;
    private String className;
    private JavaClass clazz;

    @BeforeEach
    public void setup() {
        this.packageName = "some.package";
        this.className = "AClassName";
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).build();
    }

    @Test
    public void testDefaultIsInnerClass() {
        Assertions.assertFalse((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testDefaultImports() {
        Assertions.assertNotNull((Object)this.clazz.getImports());
        Assertions.assertTrue((boolean)this.clazz.getImports().isEmpty());
    }

    @Test
    public void testDefaultStaticImports() {
        Assertions.assertNotNull((Object)this.clazz.getStaticImports());
        Assertions.assertTrue((boolean)this.clazz.getStaticImports().isEmpty());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.clazz.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertNotNull((Object)this.clazz.getAnnotations());
        Assertions.assertTrue((boolean)this.clazz.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)this.clazz.getVisibility());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.clazz.isStatic());
    }

    @Test
    public void testDefaultSuperClassName() {
        Assertions.assertNull((Object)this.clazz.getSuperClassName());
    }

    @Test
    public void testDefaultFields() {
        Assertions.assertNotNull((Object)this.clazz.getFields());
        Assertions.assertTrue((boolean)this.clazz.getFields().isEmpty());
    }

    @Test
    public void testSetIsInnerClass() {
        this.clazz = new TestJavaClassBuilder(false).className(this.className).isInnerClass(true).build();
        Assertions.assertTrue((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testSetInnerClass() {
        this.clazz = new TestJavaClassBuilder(false).className(this.className).innerClass().build();
        Assertions.assertTrue((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testSetPackageName() {
        Assertions.assertEquals((Object)this.packageName, (Object)this.clazz.getPackageName());
    }

    @Test
    public void testSetClassName() {
        Assertions.assertEquals((Object)this.className, (Object)this.clazz.getClassName());
    }

    @Test
    public void testSetImports() {
        List imports = ListUtil.createList((Object[])new String[]{"com.example.*", "com.github.tadukoo.*"});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).imports(imports).build();
        Assertions.assertEquals((Object)imports, (Object)this.clazz.getImports());
    }

    @Test
    public void testSetSingleImport() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).singleImport("com.example.*").build();
        List imports = this.clazz.getImports();
        Assertions.assertEquals((int)1, (int)imports.size());
        Assertions.assertEquals((Object)"com.example.*", imports.get(0));
    }

    @Test
    public void testSetStaticImports() {
        List staticImports = ListUtil.createList((Object[])new String[]{"com.example.Test", "com.github.tadukoo.*"});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).staticImports(staticImports).build();
        Assertions.assertEquals((Object)staticImports, (Object)this.clazz.getStaticImports());
    }

    @Test
    public void testSetSingleStaticImport() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).staticImport("com.github.tadukoo.*").build();
        List staticImports = this.clazz.getStaticImports();
        Assertions.assertEquals((int)1, (int)staticImports.size());
        Assertions.assertEquals((Object)"com.github.tadukoo.*", staticImports.get(0));
    }

    @Test
    public void testSetJavadoc() {
        Javadoc doc = UneditableJavadoc.builder().build();
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).javadoc(doc).build();
        Assertions.assertEquals((Object)doc, (Object)this.clazz.getJavadoc());
    }

    @Test
    public void testSetAnnotations() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).annotations(annotations).build();
        Assertions.assertEquals((Object)annotations, (Object)this.clazz.getAnnotations());
    }

    @Test
    public void testSetSingleAnnotation() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).annotation(test).build();
        List annotations = this.clazz.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testSetVisibility() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).visibility(Visibility.PRIVATE).build();
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.clazz.getVisibility());
    }

    @Test
    public void testSetIsStatic() {
        this.clazz = new TestJavaClassBuilder(false).innerClass().className(this.className).isStatic(true).build();
        Assertions.assertTrue((boolean)this.clazz.isStatic());
    }

    @Test
    public void testSetIsStaticNoParam() {
        this.clazz = new TestJavaClassBuilder(false).innerClass().className(this.className).isStatic().build();
        Assertions.assertTrue((boolean)this.clazz.isStatic());
    }

    @Test
    public void testSetSuperClassName() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).superClassName("AnotherClassName").build();
        Assertions.assertEquals((Object)"AnotherClassName", (Object)this.clazz.getSuperClassName());
    }

    @Test
    public void testSetInnerClasses() {
        List classes = ListUtil.createList((Object[])new JavaClass[]{new TestJavaClassBuilder(false).innerClass().className("AClass").build(), new TestJavaClassBuilder(false).innerClass().className("BClass").build()});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className("CClassName").innerClasses(classes).build();
        Assertions.assertEquals((Object)classes, (Object)this.clazz.getInnerClasses());
    }

    @Test
    public void testSet1InnerClass() {
        JavaClass class2 = new TestJavaClassBuilder(false).innerClass().className("AClass").build();
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className("BClassName").innerClass(class2).build();
        List innerClasses = this.clazz.getInnerClasses();
        Assertions.assertEquals((int)1, (int)innerClasses.size());
        Assertions.assertEquals((Object)class2, innerClasses.get(0));
    }

    @Test
    public void testSetFields() {
        List fields = ListUtil.createList((Object[])new JavaField[]{UneditableJavaField.builder().type("int").name("test").build(), UneditableJavaField.builder().type("String").name("derp").build()});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).fields(fields).build();
        Assertions.assertEquals((Object)fields, (Object)this.clazz.getFields());
    }

    @Test
    public void testSetField() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).field(UneditableJavaField.builder().type("int").name("test").build()).build();
        List fields = this.clazz.getFields();
        Assertions.assertEquals((int)1, (int)fields.size());
        JavaField field = (JavaField)fields.get(0);
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)field.getVisibility());
        Assertions.assertEquals((Object)"int", (Object)field.getType());
        Assertions.assertEquals((Object)"test", (Object)field.getName());
    }

    @Test
    public void testSetMethods() {
        List methods = ListUtil.createList((Object[])new JavaMethod[]{UneditableJavaMethod.builder().returnType("int").build(), UneditableJavaMethod.builder().returnType("String").build()});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).methods(methods).build();
        Assertions.assertEquals((Object)methods, (Object)this.clazz.getMethods());
    }

    @Test
    public void testSetMethod() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).method(UneditableJavaMethod.builder().returnType("int").name("someMethod").line("return 42;").build()).build();
        List methods = this.clazz.getMethods();
        Assertions.assertEquals((int)1, (int)methods.size());
        JavaMethod method = (JavaMethod)methods.get(0);
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)method.getVisibility());
        Assertions.assertEquals((Object)"int", (Object)method.getReturnType());
        Assertions.assertEquals((Object)"someMethod", (Object)method.getName());
        Assertions.assertTrue((boolean)method.getParameters().isEmpty());
        List lines = method.getLines();
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)"return 42;", lines.get(0));
    }

    @Test
    public void testNullPackageName() {
        try {
            this.clazz = new TestJavaClassBuilder(false).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify packageName when not making an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullClassName() {
        try {
            this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!", (Object)e.getMessage());
        }
    }

    @Test
    public void testInnerClassNotInnerClass() {
        try {
            JavaClass inner = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).build();
            this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className("BClassName").innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Inner class 'AClassName' is not an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testOuterClassCantBeStatic() {
        try {
            this.clazz = new TestJavaClassBuilder(false).isStatic().packageName(this.packageName).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Only inner classes can be static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllOuterClassErrors() {
        try {
            JavaClass inner = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).build();
            this.clazz = new TestJavaClassBuilder(false).isStatic().innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!\nInner class 'AClassName' is not an inner class!\nMust specify packageName when not making an inner class!\nOnly inner classes can be static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullClassNameInnerClass() {
        try {
            this.clazz = new TestJavaClassBuilder(false).innerClass().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!", (Object)e.getMessage());
        }
    }

    @Test
    public void testInnerClassNotInnerClassInInnerClass() {
        try {
            JavaClass inner = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).build();
            this.clazz = new TestJavaClassBuilder(false).innerClass().className("BClassName").innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Inner class 'AClassName' is not an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetPackageNameInnerClass() {
        try {
            this.clazz = new TestJavaClassBuilder(false).innerClass().packageName(this.packageName).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have packageName for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetImportInnerClass() {
        try {
            this.clazz = new TestJavaClassBuilder(false).innerClass().className(this.className).singleImport("an.import").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have imports for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetStaticImportInnerClass() {
        try {
            this.clazz = new TestJavaClassBuilder(false).innerClass().className(this.className).staticImport("an.other.import").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have static imports for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllInnerClassBuilderErrors() {
        try {
            JavaClass inner = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).build();
            this.clazz = new TestJavaClassBuilder(false).innerClass().packageName(this.packageName).innerClass(inner).singleImport("an.import").staticImport("an.other.import").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!\nInner class 'AClassName' is not an inner class!\nNot allowed to have packageName for an inner class!\nNot allowed to have imports for an inner class!\nNot allowed to have static imports for an inner class!", (Object)e.getMessage());
        }
    }

    private static class TestJavaClassBuilder
    extends JavaClassBuilder<TestJavaClass> {
        private final boolean editable;

        private TestJavaClassBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaClass constructClass() {
            return new TestJavaClass(this.editable, this.isInnerClass, this.packageName, this.imports, this.staticImports, this.javadoc, this.annotations, this.visibility, this.isStatic, this.className, this.superClassName, this.innerClasses, this.fields, this.methods);
        }
    }

    private static class TestJavaClass
    extends JavaClass {
        private TestJavaClass(boolean editable, boolean isInnerClass, String packageName, List<String> imports, List<String> staticImports, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String className, String superClassName, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods) {
            super(editable, isInnerClass, packageName, imports, staticImports, javadoc, annotations, visibility, isStatic, className, superClassName, innerClasses, fields, methods);
        }
    }
}

