/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaFieldBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaFieldTest {
    private JavaField field;
    private String type;
    private String name;

    @BeforeEach
    public void setup() {
        this.type = "int";
        this.name = "test";
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).build();
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)this.field.isEditable());
    }

    @Test
    public void testIsEditableTrue() {
        this.field = new TestJavaFieldBuilder(true).type(this.type).name(this.name).build();
        Assertions.assertTrue((boolean)this.field.isEditable());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"private int test", (Object)this.field.toString());
    }

    @Test
    public void testToStringWithSectionComment() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).sectionComment("Test comment").build();
        String javaString = "/*\n * Test comment\n */\n\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).javadoc(UneditableJavadoc.builder().build()).build();
        String javaString = "/**\n */\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithSingleAnnotation() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).annotation(test).build();
        String javaString = "@Test\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).annotation(test).annotation(derp).build();
        String javaString = "@Test\n@Derp\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithIsStatic() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).isStatic().build();
        String javaString = "private static int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithIsFinal() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).isFinal().build();
        String javaString = "private final int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithValue() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).value("42").build();
        Assertions.assertEquals((Object)"private int test = 42", (Object)this.field.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).isStatic().isFinal().value("42").build();
        String javaString = "/*\n * Test comment\n */\n\n/**\n */\n@Test\n@Derp\nprivate static final int test = 42";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testEquals() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).isStatic().isFinal().value("42").build();
        JavaField otherField = new TestJavaFieldBuilder(false).type(this.type).name(this.name).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).isStatic().isFinal().value("42").build();
        Assertions.assertEquals((Object)this.field, (Object)otherField);
    }

    @Test
    public void testEqualsNotEqual() {
        this.field = new TestJavaFieldBuilder(false).type(this.type).name(this.name).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).isStatic().isFinal().value("42").build();
        JavaField otherField = new TestJavaFieldBuilder(false).type(this.type).name(this.name).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).isStatic().isFinal().value("41").build();
        Assertions.assertNotEquals((Object)this.field, (Object)otherField);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals((Object)this.field, (Object)"testing");
    }

    private static class TestJavaFieldBuilder
    extends JavaFieldBuilder<TestJavaField> {
        private final boolean editable;

        public TestJavaFieldBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaField constructField() {
            return new TestJavaField(this.editable, this.sectionComment, this.javadoc, this.annotations, this.visibility, this.isStatic, this.isFinal, this.type, this.name, this.value);
        }
    }

    private static class TestJavaField
    extends JavaField {
        protected TestJavaField(boolean editable, String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, boolean isFinal, String type, String name, String value) {
            super(editable, sectionComment, javadoc, annotations, visibility, isStatic, isFinal, type, name, value);
        }
    }
}

