/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.JavaMethodBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaMethodBuilderTest {
    private JavaMethod method;
    private String returnType;

    @BeforeEach
    public void setup() {
        this.returnType = "int";
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).build();
    }

    @Test
    public void testDefaultSectionComment() {
        Assertions.assertNull((Object)this.method.getSectionComment());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.method.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertTrue((boolean)this.method.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)this.method.getVisibility());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.method.isStatic());
    }

    @Test
    public void testDefaultName() {
        Assertions.assertNull((Object)this.method.getName());
    }

    @Test
    public void testDefaultParameters() {
        Assertions.assertTrue((boolean)this.method.getParameters().isEmpty());
    }

    @Test
    public void testDefaultThrowTypes() {
        Assertions.assertTrue((boolean)this.method.getThrowTypes().isEmpty());
    }

    @Test
    public void testDefaultLines() {
        Assertions.assertTrue((boolean)this.method.getLines().isEmpty());
    }

    @Test
    public void testBuilderSetSectionComment() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test section").build();
        Assertions.assertEquals((Object)"Test section", (Object)this.method.getSectionComment());
    }

    @Test
    public void testBuilderSetJavadoc() {
        Javadoc javadoc = UneditableJavadoc.builder().build();
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).javadoc(javadoc).build();
        Assertions.assertEquals((Object)javadoc, (Object)this.method.getJavadoc());
    }

    @Test
    public void testBuilderSetAnnotations() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.method = new TestJavaMethodBuilder(false).annotations(annotations).returnType("String").build();
        Assertions.assertEquals((Object)annotations, (Object)this.method.getAnnotations());
    }

    @Test
    public void testBuilderSetAnnotation() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        this.method = new TestJavaMethodBuilder(false).annotation(test).returnType("String").build();
        List annotations = this.method.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testBuilderSetVisibility() {
        this.method = new TestJavaMethodBuilder(false).visibility(Visibility.PRIVATE).returnType("String").build();
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.method.getVisibility());
    }

    @Test
    public void testBuilderIsStatic() {
        this.method = new TestJavaMethodBuilder(false).isStatic().returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isStatic());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.method = new TestJavaMethodBuilder(false).isStatic(false).returnType("String").build();
        Assertions.assertFalse((boolean)this.method.isStatic());
        this.method = new TestJavaMethodBuilder(false).isStatic(true).returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isStatic());
    }

    @Test
    public void testBuilderSetReturnType() {
        Assertions.assertEquals((Object)"int", (Object)this.method.getReturnType());
    }

    @Test
    public void testBuilderSetName() {
        this.method = new TestJavaMethodBuilder(false).name("someName").returnType(this.returnType).build();
        Assertions.assertEquals((Object)"someName", (Object)this.method.getName());
    }

    @Test
    public void testBuilderSetParameters() {
        List parameters = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"int", (Object)"someInt"), Pair.of((Object)"String", (Object)"someText")});
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).parameters(parameters).build();
        Assertions.assertEquals((Object)parameters, (Object)this.method.getParameters());
    }

    @Test
    public void testBuilderSetParameterPair() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).parameter(Pair.of((Object)"String", (Object)"someText")).build();
        List parameters = this.method.getParameters();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Pair parameter = (Pair)parameters.get(0);
        Assertions.assertEquals((Object)"String", (Object)parameter.getLeft());
        Assertions.assertEquals((Object)"someText", (Object)parameter.getRight());
    }

    @Test
    public void testBuilderSetParameter() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).parameter("String", "someText").build();
        List parameters = this.method.getParameters();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Pair parameter = (Pair)parameters.get(0);
        Assertions.assertEquals((Object)"String", (Object)parameter.getLeft());
        Assertions.assertEquals((Object)"someText", (Object)parameter.getRight());
    }

    @Test
    public void testBuilderSetThrowTypes() {
        List throwTypes = ListUtil.createList((Object[])new String[]{"Throwable", "Exception"});
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).throwTypes(throwTypes).build();
        Assertions.assertEquals((Object)throwTypes, (Object)this.method.getThrowTypes());
    }

    @Test
    public void testBuilderSetThrowType() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).throwType("Throwable").build();
        List throwTypes = this.method.getThrowTypes();
        Assertions.assertEquals((int)1, (int)throwTypes.size());
        Assertions.assertEquals((Object)"Throwable", throwTypes.get(0));
    }

    @Test
    public void testBuilderSetLines() {
        List lines = ListUtil.createList((Object[])new String[]{"doSomething();", "return 42;"});
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).lines(lines).build();
        Assertions.assertEquals((Object)lines, (Object)this.method.getLines());
    }

    @Test
    public void testBuilderSetLine() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).line("return 42;").build();
        List lines = this.method.getLines();
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)"return 42;", lines.get(0));
    }

    @Test
    public void testBuilderNullReturnType() {
        try {
            this.method = new TestJavaMethodBuilder(false).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify returnType!", (Object)e.getMessage());
        }
    }

    private static class TestJavaMethodBuilder
    extends JavaMethodBuilder<TestJavaMethod> {
        private final boolean editable;

        private TestJavaMethodBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaMethod constructMethod() {
            return new TestJavaMethod(this.editable, this.sectionComment, this.javadoc, this.annotations, this.visibility, this.isStatic, this.returnType, this.name, this.parameters, this.throwTypes, this.lines);
        }
    }

    private static class TestJavaMethod
    extends JavaMethod {
        private TestJavaMethod(boolean editable, String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String returnType, String name, List<Pair<String, String>> parameters, List<String> throwTypes, List<String> lines) {
            super(editable, sectionComment, javadoc, annotations, visibility, isStatic, returnType, name, parameters, throwTypes, lines);
        }
    }
}

