/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.JavadocBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavadocBuilderTest {
    private Javadoc doc;

    @BeforeEach
    public void setup() {
        this.doc = new TestJavadocBuilder().build();
    }

    @Test
    public void testDefaultCondensed() {
        Assertions.assertFalse((boolean)this.doc.isCondensed());
    }

    @Test
    public void testDefaultContent() {
        List content = this.doc.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((int)0, (int)content.size());
    }

    @Test
    public void testDefaultAuthor() {
        Assertions.assertNull((Object)this.doc.getAuthor());
    }

    @Test
    public void testDefaultVersion() {
        Assertions.assertNull((Object)this.doc.getVersion());
    }

    @Test
    public void testDefaultSince() {
        Assertions.assertNull((Object)this.doc.getSince());
    }

    @Test
    public void testDefaultParams() {
        List params = this.doc.getParams();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)0, (int)params.size());
    }

    @Test
    public void testDefaultReturnVal() {
        Assertions.assertNull((Object)this.doc.getReturnVal());
    }

    @Test
    public void testBuilderSetCondensedValue() {
        this.doc = new TestJavadocBuilder().condensed(true).build();
        Assertions.assertTrue((boolean)this.doc.isCondensed());
    }

    @Test
    public void testBuilderSetCondensed() {
        this.doc = new TestJavadocBuilder().condensed().build();
        Assertions.assertTrue((boolean)this.doc.isCondensed());
    }

    @Test
    public void testBuilderSetContent() {
        List content = ListUtil.createList((Object[])new String[]{"test", "derp"});
        this.doc = new TestJavadocBuilder().content(content).build();
        Assertions.assertEquals((Object)content, (Object)this.doc.getContent());
    }

    @Test
    public void testBuilderSetContentLine() {
        String content = "test";
        this.doc = new TestJavadocBuilder().content(content).build();
        List actContent = this.doc.getContent();
        Assertions.assertEquals((int)1, (int)actContent.size());
        Assertions.assertEquals((Object)content, actContent.get(0));
    }

    @Test
    public void testBuilderSetAuthor() {
        this.doc = new TestJavadocBuilder().author("Logan Ferree (Tadukoo)").build();
        Assertions.assertEquals((Object)"Logan Ferree (Tadukoo)", (Object)this.doc.getAuthor());
    }

    @Test
    public void testBuilderSetVersion() {
        this.doc = new TestJavadocBuilder().version("Alpha v.0.1").build();
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)this.doc.getVersion());
    }

    @Test
    public void testBuilderSetSince() {
        this.doc = new TestJavadocBuilder().since("Alpha v.0.0.1").build();
        Assertions.assertEquals((Object)"Alpha v.0.0.1", (Object)this.doc.getSince());
    }

    @Test
    public void testBuilderSetParams() {
        List params = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")});
        this.doc = new TestJavadocBuilder().params(params).build();
        Assertions.assertEquals((Object)params, (Object)this.doc.getParams());
    }

    @Test
    public void testBuilderSetParamPair() {
        Pair param = Pair.of((Object)"test", (Object)"yes");
        this.doc = new TestJavadocBuilder().param(param).build();
        List params = this.doc.getParams();
        Assertions.assertEquals((int)1, (int)params.size());
        Assertions.assertEquals((Object)param, params.get(0));
    }

    @Test
    public void testBuilderSetParamPieces() {
        this.doc = new TestJavadocBuilder().param("test", "yes").build();
        List params = this.doc.getParams();
        Assertions.assertEquals((int)1, (int)params.size());
        Pair param = (Pair)params.get(0);
        Assertions.assertEquals((Object)"test", (Object)param.getLeft());
        Assertions.assertEquals((Object)"yes", (Object)param.getRight());
    }

    @Test
    public void testBuilderSetReturnVal() {
        this.doc = new TestJavadocBuilder().returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"this, to continue building", (Object)this.doc.getReturnVal());
    }

    @Test
    public void testBuilderSetAll() {
        List content = ListUtil.createList((Object[])new String[]{"test", "derp"});
        List params = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")});
        this.doc = new TestJavadocBuilder().condensed().content(content).author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").params(params).returnVal("this, to continue building").build();
        Assertions.assertTrue((boolean)this.doc.isCondensed());
        Assertions.assertEquals((Object)content, (Object)this.doc.getContent());
        Assertions.assertEquals((Object)"Logan Ferree (Tadukoo)", (Object)this.doc.getAuthor());
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)this.doc.getVersion());
        Assertions.assertEquals((Object)"Alpha v.0.0.1", (Object)this.doc.getSince());
        Assertions.assertEquals((Object)params, (Object)this.doc.getParams());
        Assertions.assertEquals((Object)"this, to continue building", (Object)this.doc.getReturnVal());
    }

    private static class TestJavadocBuilder
    extends JavadocBuilder<TestJavadoc> {
        private TestJavadocBuilder() {
        }

        protected TestJavadoc constructJavadoc() {
            return new TestJavadoc(this.condensed, this.content, this.author, this.version, this.since, this.params, this.returnVal);
        }
    }

    private static class TestJavadoc
    extends Javadoc {
        protected TestJavadoc(boolean condensed, List<String> content, String author, String version, String since, List<Pair<String, String>> params, String returnVal) {
            super(false, condensed, content, author, version, since, params, returnVal);
        }
    }
}

