/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.JavadocBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavadocTest {
    private Javadoc doc;

    @BeforeEach
    public void setup() {
        this.doc = new TestJavadocBuilder(false).build();
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)this.doc.isEditable());
    }

    @Test
    public void testIsEditableTrue() {
        this.doc = new TestJavadocBuilder(true).build();
        Assertions.assertTrue((boolean)this.doc.isEditable());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"/**\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithContent() {
        this.doc = new TestJavadocBuilder(false).content(ListUtil.createList((Object[])new String[]{"test", "derp"})).build();
        Assertions.assertEquals((Object)"/**\n * test\n * derp\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithAuthor() {
        this.doc = new TestJavadocBuilder(false).author("Logan Ferree (Tadukoo)").build();
        Assertions.assertEquals((Object)"/**\n * @author Logan Ferree (Tadukoo)\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithVersion() {
        this.doc = new TestJavadocBuilder(false).version("Alpha v.0.1").build();
        Assertions.assertEquals((Object)"/**\n * @version Alpha v.0.1\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSince() {
        this.doc = new TestJavadocBuilder(false).since("Alpha v.0.0.1").build();
        Assertions.assertEquals((Object)"/**\n * @since Alpha v.0.0.1\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSingleParam() {
        this.doc = new TestJavadocBuilder(false).param("test", "yes").build();
        Assertions.assertEquals((Object)"/**\n * @param test yes\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithMultipleParams() {
        this.doc = new TestJavadocBuilder(false).params(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")})).build();
        Assertions.assertEquals((Object)"/**\n * @param test yes\n * @param derp no\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithReturnVal() {
        this.doc = new TestJavadocBuilder(false).returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/**\n * @return this, to continue building\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.doc = new TestJavadocBuilder(false).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/**\n * test\n * derp\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n * @since Alpha v.0.0.1\n * \n * @param test yes\n * @param derp no\n * @return this, to continue building\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).build();
        Assertions.assertEquals((Object)"/** */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithContentCondensed() {
        List content = ListUtil.createList((Object[])new String[]{"test", "derp"});
        this.doc = new TestJavadocBuilder(false).condensed(true).content(content).build();
        Assertions.assertEquals((Object)"/** test\n * derp */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithAuthorCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).author("Logan Ferree (Tadukoo)").build();
        Assertions.assertEquals((Object)"/** @author Logan Ferree (Tadukoo) */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithVersionCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).version("Alpha v.0.1").build();
        Assertions.assertEquals((Object)"/** @version Alpha v.0.1 */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSinceCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).since("Alpha v.0.0.1").build();
        Assertions.assertEquals((Object)"/** @since Alpha v.0.0.1 */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSingleParamCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).param("test", "yes").build();
        Assertions.assertEquals((Object)"/** @param test yes */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithMultipleParamsCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).params(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")})).build();
        Assertions.assertEquals((Object)"/** @param test yes\n * @param derp no */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithReturnValCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/** @return this, to continue building */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithEverythingCondensed() {
        this.doc = new TestJavadocBuilder(false).condensed(true).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/** test\n * derp\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n * @since Alpha v.0.0.1\n * \n * @param test yes\n * @param derp no\n * @return this, to continue building */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringContentAndInfoAnnotations() {
        this.doc = new TestJavadocBuilder(false).content("test").author("Me").build();
        Assertions.assertEquals((Object)"/**\n * test\n * \n * @author Me\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringContentAndCodeAnnotations() {
        this.doc = new TestJavadocBuilder(false).content("test").returnVal("this").build();
        this.doc = new Javadoc(false, false, ListUtil.createList((Object[])new String[]{"test"}), null, null, null, new ArrayList(), "this"){};
        Assertions.assertEquals((Object)"/**\n * test\n * \n * @return this\n */", (Object)this.doc.toString());
    }

    @Test
    public void testEquals() {
        this.doc = new TestJavadocBuilder(false).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Javadoc otherDoc = new TestJavadocBuilder(false).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)otherDoc, (Object)this.doc);
    }

    @Test
    public void testEqualsNotEqual() {
        this.doc = new TestJavadocBuilder(false).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Javadoc otherDoc = new TestJavadocBuilder(false).content("tes").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertNotEquals((Object)otherDoc, (Object)this.doc);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals((Object)this.doc, (Object)"test");
    }

    private static class TestJavadocBuilder
    extends JavadocBuilder<TestJavadoc> {
        private final boolean editable;

        public TestJavadocBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavadoc constructJavadoc() {
            return new TestJavadoc(this.editable, this.condensed, this.content, this.author, this.version, this.since, this.params, this.returnVal);
        }
    }

    private static class TestJavadoc
    extends Javadoc {
        protected TestJavadoc(boolean editable, boolean condensed, List<String> content, String author, String version, String since, List<Pair<String, String>> params, String returnVal) {
            super(editable, condensed, content, author, version, since, params, returnVal);
        }
    }
}

