/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.editable;

import com.github.tadukoo.java.DefaultJavadocTest;
import com.github.tadukoo.java.editable.EditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditableJavadocTest
extends DefaultJavadocTest<EditableJavadoc> {
    public EditableJavadocTest() {
        super(EditableJavadoc::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)((EditableJavadoc)this.doc).isEditable());
    }

    @Test
    public void testSetCondensed() {
        Assertions.assertFalse((boolean)((EditableJavadoc)this.doc).isCondensed());
        ((EditableJavadoc)this.doc).setCondensed(true);
        Assertions.assertTrue((boolean)((EditableJavadoc)this.doc).isCondensed());
    }

    @Test
    public void testAddContentSingleLine() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getContent());
        ((EditableJavadoc)this.doc).addContent("Test");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test"}), (Object)((EditableJavadoc)this.doc).getContent());
        ((EditableJavadoc)this.doc).addContent("Derp");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp"}), (Object)((EditableJavadoc)this.doc).getContent());
    }

    @Test
    public void testAddContentMultiline() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getContent());
        ((EditableJavadoc)this.doc).addContent(ListUtil.createList((Object[])new String[]{"Test", "Derp"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp"}), (Object)((EditableJavadoc)this.doc).getContent());
        ((EditableJavadoc)this.doc).addContent(ListUtil.createList((Object[])new String[]{"blah", "yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp", "blah", "yep"}), (Object)((EditableJavadoc)this.doc).getContent());
    }

    @Test
    public void testSetContent() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getContent());
        ((EditableJavadoc)this.doc).setContent(ListUtil.createList((Object[])new String[]{"Test", "Derp"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp"}), (Object)((EditableJavadoc)this.doc).getContent());
        ((EditableJavadoc)this.doc).setContent(ListUtil.createList((Object[])new String[]{"blah", "yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"blah", "yep"}), (Object)((EditableJavadoc)this.doc).getContent());
    }

    @Test
    public void testSetAuthor() {
        Assertions.assertNull((Object)((EditableJavadoc)this.doc).getAuthor());
        ((EditableJavadoc)this.doc).setAuthor("Me");
        Assertions.assertEquals((Object)"Me", (Object)((EditableJavadoc)this.doc).getAuthor());
        ((EditableJavadoc)this.doc).setAuthor("Logan Ferree (Tadukoo)");
        Assertions.assertEquals((Object)"Logan Ferree (Tadukoo)", (Object)((EditableJavadoc)this.doc).getAuthor());
    }

    @Test
    public void testSetVersion() {
        Assertions.assertNull((Object)((EditableJavadoc)this.doc).getVersion());
        ((EditableJavadoc)this.doc).setVersion("Test");
        Assertions.assertEquals((Object)"Test", (Object)((EditableJavadoc)this.doc).getVersion());
        ((EditableJavadoc)this.doc).setVersion("Alpha v.0.1");
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)((EditableJavadoc)this.doc).getVersion());
    }

    @Test
    public void testSetSince() {
        Assertions.assertNull((Object)((EditableJavadoc)this.doc).getSince());
        ((EditableJavadoc)this.doc).setSince("Test");
        Assertions.assertEquals((Object)"Test", (Object)((EditableJavadoc)this.doc).getSince());
        ((EditableJavadoc)this.doc).setSince("Alpha v.0.1");
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)((EditableJavadoc)this.doc).getSince());
    }

    @Test
    public void testAddParamPieces() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).addParam("Test", "something");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something")}), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).addParam("Derp", "something else");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)((EditableJavadoc)this.doc).getParams());
    }

    @Test
    public void testAddParamPair() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).addParam(Pair.of((Object)"Test", (Object)"something"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something")}), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).addParam(Pair.of((Object)"Derp", (Object)"something else"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)((EditableJavadoc)this.doc).getParams());
    }

    @Test
    public void testAddParams() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).addParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).addParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else"), Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}), (Object)((EditableJavadoc)this.doc).getParams());
    }

    @Test
    public void testSetParams() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).setParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)((EditableJavadoc)this.doc).getParams());
        ((EditableJavadoc)this.doc).setParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}), (Object)((EditableJavadoc)this.doc).getParams());
    }

    @Test
    public void testSetReturnVal() {
        Assertions.assertNull((Object)((EditableJavadoc)this.doc).getReturnVal());
        ((EditableJavadoc)this.doc).setReturnVal("a string");
        Assertions.assertEquals((Object)"a string", (Object)((EditableJavadoc)this.doc).getReturnVal());
        ((EditableJavadoc)this.doc).setReturnVal("this");
        Assertions.assertEquals((Object)"this", (Object)((EditableJavadoc)this.doc).getReturnVal());
    }
}

