/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaClass {
    private final boolean editable;
    protected boolean isInnerClass;
    protected String packageName;
    protected List<String> imports;
    protected List<String> staticImports;
    protected Javadoc javadoc;
    protected List<JavaAnnotation> annotations;
    protected Visibility visibility;
    protected boolean isStatic;
    protected String className;
    protected String superClassName;
    protected List<JavaClass> innerClasses;
    protected List<JavaField> fields;
    protected List<JavaMethod> methods;

    protected JavaClass(boolean editable, boolean isInnerClass, String packageName, List<String> imports, List<String> staticImports, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String className, String superClassName, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods) {
        this.editable = editable;
        this.isInnerClass = isInnerClass;
        this.packageName = packageName;
        this.imports = imports;
        this.staticImports = staticImports;
        this.javadoc = javadoc;
        this.annotations = annotations;
        this.visibility = visibility;
        this.isStatic = isStatic;
        this.className = className;
        this.superClassName = superClassName;
        this.innerClasses = innerClasses;
        this.fields = fields;
        this.methods = methods;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<String> getStaticImports() {
        return this.staticImports;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public List<JavaClass> getInnerClasses() {
        return this.innerClasses;
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public String toString() {
        ArrayList<Object> content = new ArrayList<Object>();
        if (!this.isInnerClass) {
            content.add("package " + this.packageName + ";");
        }
        if (ListUtil.isNotBlank(this.imports)) {
            content.add("");
            for (String singleImport : this.imports) {
                if (StringUtil.isNotBlank((String)singleImport)) {
                    content.add("import " + singleImport + ";");
                    continue;
                }
                content.add("");
            }
        }
        if (ListUtil.isNotBlank(this.staticImports)) {
            content.add("");
            for (String staticImport : this.staticImports) {
                if (StringUtil.isNotBlank((String)staticImport)) {
                    content.add("import static " + staticImport + ";");
                    continue;
                }
                content.add("");
            }
        }
        if (!this.isInnerClass) {
            content.add("");
        }
        if (this.javadoc != null) {
            content.add(this.javadoc.toString());
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                content.add(annotation.toString());
            }
        }
        content.add(this.visibility.getText() + (this.isStatic ? " static" : "") + " class " + this.className + (String)(StringUtil.isNotBlank((String)this.superClassName) ? " extends " + this.superClassName : "") + "{");
        content.add("\t");
        if (ListUtil.isNotBlank(this.innerClasses)) {
            for (JavaClass clazz : this.innerClasses) {
                content.add(StringUtil.indentAllLines((String)clazz.toString()));
            }
        }
        if (ListUtil.isNotBlank(this.fields)) {
            for (JavaField field : this.fields) {
                content.add(StringUtil.indentAllLines((String)field.toString()) + ";");
            }
        }
        if (ListUtil.isNotBlank(this.methods)) {
            if (ListUtil.isNotBlank(this.fields)) {
                content.add("\t");
            }
            for (JavaMethod method : this.methods) {
                List lines = StringUtil.parseListFromStringWithSeparator((String)method.toString(), (String)"\n", (boolean)false);
                for (String line : lines) {
                    content.add("\t" + line);
                }
                content.add("\t");
            }
            content.remove(content.size() - 1);
        }
        content.add("}");
        content.add("");
        return StringUtil.buildStringWithNewLines(content);
    }

    public boolean equals(Object otherClass) {
        if (otherClass instanceof JavaClass) {
            JavaClass clazz = (JavaClass)otherClass;
            return StringUtil.equals((String)this.toString(), (String)clazz.toString());
        }
        return false;
    }
}

