/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaClassBuilder<ClassType extends JavaClass> {
    protected boolean isInnerClass = false;
    protected String packageName = null;
    protected List<String> imports = new ArrayList<String>();
    protected List<String> staticImports = new ArrayList<String>();
    protected Javadoc javadoc = null;
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    protected Visibility visibility = Visibility.PUBLIC;
    protected boolean isStatic = false;
    protected String className = null;
    protected String superClassName = null;
    protected List<JavaClass> innerClasses = new ArrayList<JavaClass>();
    protected List<JavaField> fields = new ArrayList<JavaField>();
    protected List<JavaMethod> methods = new ArrayList<JavaMethod>();

    protected JavaClassBuilder() {
    }

    public JavaClassBuilder<ClassType> isInnerClass(boolean isInnerClass) {
        this.isInnerClass = isInnerClass;
        return this;
    }

    public JavaClassBuilder<ClassType> innerClass() {
        this.isInnerClass = true;
        return this;
    }

    public JavaClassBuilder<ClassType> packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public JavaClassBuilder<ClassType> imports(List<String> imports) {
        this.imports = imports;
        return this;
    }

    public JavaClassBuilder<ClassType> singleImport(String singleImport) {
        this.imports.add(singleImport);
        return this;
    }

    public JavaClassBuilder<ClassType> staticImports(List<String> staticImports) {
        this.staticImports = staticImports;
        return this;
    }

    public JavaClassBuilder<ClassType> staticImport(String staticImport) {
        this.staticImports.add(staticImport);
        return this;
    }

    public JavaClassBuilder<ClassType> javadoc(Javadoc javadoc) {
        this.javadoc = javadoc;
        return this;
    }

    public JavaClassBuilder<ClassType> annotations(List<JavaAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public JavaClassBuilder<ClassType> annotation(JavaAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public JavaClassBuilder<ClassType> visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public JavaClassBuilder<ClassType> isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaClassBuilder<ClassType> isStatic() {
        this.isStatic = true;
        return this;
    }

    public JavaClassBuilder<ClassType> className(String className) {
        this.className = className;
        return this;
    }

    public JavaClassBuilder<ClassType> superClassName(String superClassName) {
        this.superClassName = superClassName;
        return this;
    }

    public JavaClassBuilder<ClassType> innerClasses(List<JavaClass> innerClasses) {
        this.innerClasses = innerClasses;
        return this;
    }

    public JavaClassBuilder<ClassType> innerClass(JavaClass innerClass) {
        this.innerClasses.add(innerClass);
        return this;
    }

    public JavaClassBuilder<ClassType> fields(List<JavaField> fields) {
        this.fields = fields;
        return this;
    }

    public JavaClassBuilder<ClassType> field(JavaField field) {
        this.fields.add(field);
        return this;
    }

    public JavaClassBuilder<ClassType> methods(List<JavaMethod> methods) {
        this.methods = methods;
        return this;
    }

    public JavaClassBuilder<ClassType> method(JavaMethod method) {
        this.methods.add(method);
        return this;
    }

    private void checkForErrors() {
        ArrayList<Object> errors = new ArrayList<Object>();
        if (StringUtil.isBlank((String)this.className)) {
            errors.add("Must specify className!");
        }
        if (ListUtil.isNotBlank(this.innerClasses)) {
            for (JavaClass innerClass : this.innerClasses) {
                if (innerClass.isInnerClass()) continue;
                errors.add("Inner class '" + innerClass.getClassName() + "' is not an inner class!");
            }
        }
        if (this.isInnerClass) {
            if (StringUtil.isNotBlank((String)this.packageName)) {
                errors.add("Not allowed to have packageName for an inner class!");
            }
            if (ListUtil.isNotBlank(this.imports)) {
                errors.add("Not allowed to have imports for an inner class!");
            }
            if (ListUtil.isNotBlank(this.staticImports)) {
                errors.add("Not allowed to have static imports for an inner class!");
            }
        } else {
            if (StringUtil.isBlank((String)this.packageName)) {
                errors.add("Must specify packageName when not making an inner class!");
            }
            if (this.isStatic) {
                errors.add("Only inner classes can be static!");
            }
        }
        errors.addAll(this.checkForSpecificErrors());
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    protected abstract List<String> checkForSpecificErrors();

    public ClassType build() {
        this.checkForErrors();
        return this.constructClass();
    }

    protected abstract ClassType constructClass();
}

