/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaField {
    private final boolean editable;
    protected String sectionComment;
    protected Javadoc javadoc;
    protected List<JavaAnnotation> annotations;
    protected Visibility visibility;
    protected boolean isStatic;
    protected boolean isFinal;
    protected String type;
    protected String name;
    protected String value;

    protected JavaField(boolean editable, String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, boolean isFinal, String type, String name, String value) {
        this.editable = editable;
        this.sectionComment = sectionComment;
        this.javadoc = javadoc;
        this.annotations = annotations;
        this.visibility = visibility;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getSectionComment() {
        return this.sectionComment;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        ArrayList<Object> content = new ArrayList<Object>();
        if (StringUtil.isNotBlank((String)this.sectionComment)) {
            content.add("/*");
            content.add(" * " + this.sectionComment);
            content.add(" */");
            content.add("");
        }
        if (this.javadoc != null) {
            content.add(this.javadoc.toString());
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                content.add(annotation.toString());
            }
        }
        String declaration = this.visibility.getText() + (this.isStatic ? " static" : "") + (this.isFinal ? " final" : "") + " " + this.type + " " + this.name;
        if (StringUtil.isNotBlank((String)this.value)) {
            declaration = declaration + " = " + this.value;
        }
        content.add(declaration);
        return StringUtil.buildStringWithNewLines(content);
    }

    public boolean equals(Object otherField) {
        if (otherField instanceof JavaField) {
            JavaField field = (JavaField)otherField;
            return StringUtil.equals((String)this.toString(), (String)field.toString());
        }
        return false;
    }
}

