/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaMethodBuilder<MethodType extends JavaMethod> {
    protected String sectionComment = null;
    protected Javadoc javadoc = null;
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    protected Visibility visibility = Visibility.PUBLIC;
    protected boolean isStatic = false;
    protected String returnType = null;
    protected String name = null;
    protected List<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
    protected List<String> throwTypes = new ArrayList<String>();
    protected List<String> lines = new ArrayList<String>();

    protected JavaMethodBuilder() {
    }

    public JavaMethodBuilder<MethodType> sectionComment(String sectionComment) {
        this.sectionComment = sectionComment;
        return this;
    }

    public JavaMethodBuilder<MethodType> javadoc(Javadoc javadoc) {
        this.javadoc = javadoc;
        return this;
    }

    public JavaMethodBuilder<MethodType> annotations(List<JavaAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public JavaMethodBuilder<MethodType> annotation(JavaAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public JavaMethodBuilder<MethodType> visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public JavaMethodBuilder<MethodType> isStatic() {
        this.isStatic = true;
        return this;
    }

    public JavaMethodBuilder<MethodType> isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaMethodBuilder<MethodType> returnType(String returnType) {
        this.returnType = returnType;
        return this;
    }

    public JavaMethodBuilder<MethodType> name(String name) {
        this.name = name;
        return this;
    }

    public JavaMethodBuilder<MethodType> parameters(List<Pair<String, String>> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JavaMethodBuilder<MethodType> parameter(Pair<String, String> parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public JavaMethodBuilder<MethodType> parameter(String type, String name) {
        this.parameters.add((Pair<String, String>)Pair.of((Object)type, (Object)name));
        return this;
    }

    public JavaMethodBuilder<MethodType> throwTypes(List<String> throwTypes) {
        this.throwTypes = throwTypes;
        return this;
    }

    public JavaMethodBuilder<MethodType> throwType(String throwType) {
        this.throwTypes.add(throwType);
        return this;
    }

    public JavaMethodBuilder<MethodType> lines(List<String> lines) {
        this.lines = lines;
        return this;
    }

    public JavaMethodBuilder<MethodType> line(String line) {
        this.lines.add(line);
        return this;
    }

    private void checkForErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isBlank((String)this.returnType)) {
            errors.add("Must specify returnType!");
        }
        errors.addAll(this.checkForSpecificErrors());
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    protected abstract List<String> checkForSpecificErrors();

    public MethodType build() {
        this.checkForErrors();
        return this.constructMethod();
    }

    protected abstract MethodType constructMethod();
}

